/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import hudson.util.ByteArrayOutputStream2;
import java.io.IOException;
import java.io.OutputStream;

public abstract class LineTransformationOutputStream
extends OutputStream {
    private boolean sawCR;
    private ByteArrayOutputStream2 buf = new ByteArrayOutputStream2();

    protected abstract void eol(byte[] var1, int var2) throws IOException;

    @Override
    public void write(int b) throws IOException {
        if (this.sawCR && b != 10) {
            this.eol();
        }
        this.buf.write(b);
        if (b == 10) {
            this.eol();
        } else if (b == 13) {
            this.sawCR = true;
        }
    }

    private void eol() throws IOException {
        this.eol(this.buf.getBuffer(), this.buf.size());
        if (this.buf.size() > 4096) {
            this.buf = new ByteArrayOutputStream2();
        } else {
            this.buf.reset();
        }
        this.sawCR = false;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int end = off + len;
        for (int i = off; i < end; ++i) {
            this.write(b[i]);
        }
    }

    @Override
    public void close() throws IOException {
        this.forceEol();
    }

    public void forceEol() throws IOException {
        if (this.buf.size() > 0) {
            this.eol();
        }
    }

    protected String trimEOL(String line) {
        char ch;
        int slen;
        for (slen = line.length(); slen > 0 && ((ch = line.charAt(slen - 1)) == '\r' || ch == '\n'); --slen) {
        }
        line = line.substring(0, slen);
        return line;
    }

    public static abstract class Delegating
    extends LineTransformationOutputStream {
        protected final OutputStream out;

        protected Delegating(OutputStream out) {
            this.out = out;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.out.close();
        }
    }
}

