/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.crypto;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.HexFormat;

public class RSAPublicKeyUtil {
    private static final HexFormat HEX_FORMAT = HexFormat.ofDelimiter(":");

    public static PublicKey readPublicKey(String keyLine) throws GeneralSecurityException {
        String[] tokens = keyLine.split(" ");
        if (tokens.length < 2) {
            throw new IllegalArgumentException("Invalid public key format: " + keyLine);
        }
        byte[] bytes = Base64.getDecoder().decode(tokens[1]);
        DataInputStream2 in = new DataInputStream2(new ByteArrayInputStream(bytes));
        try {
            String type = in.decodeString();
            if (type.equals("ssh-rsa")) {
                BigInteger e = in.readBigInt();
                BigInteger m = in.readBigInt();
                RSAPublicKeySpec spec = new RSAPublicKeySpec(m, e);
                return KeyFactory.getInstance("RSA").generatePublic(spec);
            }
            if (type.equals("ssh-dss")) {
                BigInteger p = in.readBigInt();
                BigInteger q = in.readBigInt();
                BigInteger g = in.readBigInt();
                BigInteger y = in.readBigInt();
                DSAPublicKeySpec spec = new DSAPublicKeySpec(y, p, q, g);
                return KeyFactory.getInstance("DSA").generatePublic(spec);
            }
            throw new IllegalArgumentException("unknown type " + type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid public key format: " + keyLine, e);
        }
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="Used for fingerprinting, not security.")
    public static String getFingerPrint(PublicKey key) throws GeneralSecurityException {
        byte[] extractedBytes = RSAPublicKeyUtil.encode(key);
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(extractedBytes);
        return RSAPublicKeyUtil.toHex(digest);
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="Used for fingerprinting, not security.")
    public static String getEC2FingerPrint(Key publicKey) throws GeneralSecurityException {
        byte[] extractedBytes = publicKey.getEncoded();
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(extractedBytes);
        return RSAPublicKeyUtil.toHex(digest);
    }

    private static String toHex(byte[] digest) {
        return HEX_FORMAT.formatHex(digest);
    }

    public static byte[] encode(PublicKey key) throws GeneralSecurityException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream2 out = new DataOutputStream2(baos);
            if (key instanceof RSAPublicKey) {
                RSAPublicKeySpec spec = KeyFactory.getInstance("RSA").getKeySpec(key, RSAPublicKeySpec.class);
                out.writeString("ssh-rsa");
                out.writeBigInt(spec.getPublicExponent());
                out.writeBigInt(spec.getModulus());
                return baos.toByteArray();
            }
            if (key instanceof DSAPublicKey) {
                DSAPublicKeySpec dsaspec = KeyFactory.getInstance("DSA").getKeySpec(key, DSAPublicKeySpec.class);
                out.writeString("ssh-dss");
                out.writeBigInt(dsaspec.getP());
                out.writeBigInt(dsaspec.getQ());
                out.writeBigInt(dsaspec.getG());
                out.writeBigInt(dsaspec.getY());
                return baos.toByteArray();
            }
            throw new IllegalArgumentException("Unexpected key type: " + String.valueOf(key));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    static class DataInputStream2
    extends DataInputStream {
        DataInputStream2(InputStream in) {
            super(in);
        }

        public String decodeString() throws IOException {
            int len = this.readInt();
            byte[] buf = new byte[len];
            this.readFully(buf);
            return new String(buf, Charset.defaultCharset());
        }

        private BigInteger readBigInt() throws IOException {
            int len = this.readInt();
            byte[] buf = new byte[len];
            this.readFully(buf);
            return new BigInteger(buf);
        }
    }

    static class DataOutputStream2
    extends DataOutputStream {
        DataOutputStream2(OutputStream out) {
            super(out);
        }

        public void writeString(String s) throws IOException {
            this.writeBinary(s.getBytes(Charset.defaultCharset()));
        }

        public void writeBinary(byte[] buf) throws IOException {
            this.writeInt(buf.length);
            this.write(buf);
        }

        private void writeBigInt(BigInteger i) throws IOException {
            this.writeBinary(i.toByteArray());
        }
    }
}

