/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import jenkins.util.InterceptingExecutorService;

public class ContextResettingExecutorService
extends InterceptingExecutorService {
    public ContextResettingExecutorService(ExecutorService base) {
        super(base);
    }

    @Override
    protected Runnable wrap(final Runnable r) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread t = Thread.currentThread();
                String name = t.getName();
                ClassLoader cl = t.getContextClassLoader();
                try {
                    r.run();
                }
                finally {
                    t.setName(name);
                    t.setContextClassLoader(cl);
                }
            }
        };
    }

    @Override
    protected <V> Callable<V> wrap(final Callable<V> r) {
        return new Callable<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V call() throws Exception {
                Thread t = Thread.currentThread();
                String name = t.getName();
                ClassLoader cl = t.getContextClassLoader();
                try {
                    Object v = r.call();
                    return v;
                }
                finally {
                    t.setName(name);
                    t.setContextClassLoader(cl);
                }
            }
        };
    }
}

