/*
 * Decompiled with CFR 0.152.
 */
package jenkins.health;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.InvisibleAction;
import hudson.model.UnprotectedRootAction;
import hudson.util.RemotingDiagnostics;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.health.HealthCheck;
import jenkins.util.JenkinsJVM;
import jenkins.util.SystemProperties;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.json.JsonHttpResponse;

@Extension
@Restricted(value={NoExternalUse.class})
public final class HealthCheckAction
extends InvisibleAction
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(HealthCheckAction.class.getName());
    private static final Duration THRESHOLD_TIMEOUT = SystemProperties.getDuration(HealthCheckAction.class.getName() + ".thresholdTimeout", Duration.ofSeconds(10L));

    @Override
    public String getUrlName() {
        return "health";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse doIndex() {
        boolean success = true;
        JSONArray failing = new JSONArray();
        Timer watchdog = new Timer("HealthCheckActionWatchdog", true);
        watchdog.schedule(new TimerTask(){

            @Override
            public void run() {
                if (JenkinsJVM.isJenkinsJVM()) {
                    try {
                        Map<String, String> threadDump = RemotingDiagnostics.getThreadDump(FilePath.localChannel);
                        LOGGER.severe(() -> "health check did not complete in timely fashion:\n\n" + threadDump.values().stream().collect(Collectors.joining()).trim());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to get thread dump during slow health check", e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }, THRESHOLD_TIMEOUT.toMillis());
        try {
            for (HealthCheck healthCheck : ExtensionList.lookup(HealthCheck.class)) {
                boolean check = healthCheck.check();
                success &= check;
                if (check) continue;
                failing.add((Object)healthCheck.getName());
            }
            JSONObject payload = new JSONObject().element("status", success);
            if (!success) {
                payload = payload.element("failures", (Collection)failing);
            }
            JsonHttpResponse jsonHttpResponse = new JsonHttpResponse(payload, success ? 200 : 503);
            return jsonHttpResponse;
        }
        finally {
            watchdog.cancel();
        }
    }
}

