/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.remoting.util.ByteBufferPool;

public class DirectByteBufferPool
implements ByteBufferPool {
    @GuardedBy(value="this")
    private final ByteBuffer[] pool;
    private final int bufferSize;
    @GuardedBy(value="this")
    private int poolCount;

    public DirectByteBufferPool(int minBufferSize, int maxPoolSize) {
        this.pool = new ByteBuffer[maxPoolSize];
        this.bufferSize = minBufferSize;
        this.poolCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer acquire(int size) {
        DirectByteBufferPool directByteBufferPool = this;
        synchronized (directByteBufferPool) {
            if (this.poolCount > 0) {
                if (size <= this.bufferSize) {
                    --this.poolCount;
                    ByteBuffer result = this.pool[this.poolCount];
                    this.pool[this.poolCount] = null;
                    ((Buffer)result).limit(size);
                    return result;
                }
                for (int i = 0; i < this.poolCount; ++i) {
                    if (this.pool[i].capacity() < size) continue;
                    ByteBuffer result = this.pool[i];
                    --this.poolCount;
                    this.pool[i] = this.pool[this.poolCount];
                    this.pool[this.poolCount] = null;
                    ((Buffer)result).limit(size);
                    return result;
                }
            }
        }
        ByteBuffer result = ByteBuffer.allocateDirect(Math.max(this.bufferSize, size));
        ((Buffer)result).limit(size);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ByteBuffer buffer) {
        if (buffer.isDirect() && !buffer.isReadOnly() && buffer.capacity() >= this.bufferSize) {
            DirectByteBufferPool directByteBufferPool = this;
            synchronized (directByteBufferPool) {
                if (this.poolCount < this.pool.length) {
                    ((Buffer)buffer).clear();
                    this.pool[this.poolCount++] = buffer;
                }
            }
        }
    }
}

