/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.Channel;
import hudson.remoting.Checksum;
import hudson.remoting.JarCache;
import hudson.remoting.ResourceImageDirect;
import hudson.remoting.ResourceImageInJar;
import hudson.remoting.URLish;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

class ResourceImageBoth
extends ResourceImageDirect {
    final long sum1;
    final long sum2;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ResourceImageBoth.class.getName());

    public ResourceImageBoth(URL resource, Checksum sum) throws IOException {
        super(resource);
        this.sum1 = sum.sum1;
        this.sum2 = sum.sum2;
    }

    @Override
    Future<byte[]> resolve(Channel channel, String resourcePath) throws IOException, InterruptedException {
        this.initiateJarRetrieval(channel);
        return super.resolve(channel, resourcePath);
    }

    @Override
    Future<URLish> resolveURL(Channel channel, String resourcePath) throws IOException, InterruptedException {
        Future<URL> f = this.initiateJarRetrieval(channel);
        if (f.isDone()) {
            return new ResourceImageInJar(this.sum1, this.sum2, null).resolveURL(channel, resourcePath);
        }
        return super.resolveURL(channel, resourcePath);
    }

    @NonNull
    private Future<URL> initiateJarRetrieval(@NonNull Channel channel) throws IOException, InterruptedException {
        JarCache c = channel.getJarCache();
        if (c == null) {
            throw new IOException("Failed to initiate retrieval. JAR Cache is disabled for the channel " + channel.getName());
        }
        try {
            return c.resolve(channel, this.sum1, this.sum2);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to initiate retrieval", e);
            throw e;
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Failed to initiate retrieval", e);
            Thread.currentThread().interrupt();
            throw e;
        }
    }
}

