/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server.internal;

import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.ExtensionStack;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.Negotiated;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.WebSocketConnection;
import org.eclipse.jetty.websocket.core.WebSocketConstants;
import org.eclipse.jetty.websocket.core.WebSocketCoreSession;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.core.server.Handshaker;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import org.eclipse.jetty.websocket.core.server.internal.WebSocketNegotiation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHandshaker
implements Handshaker {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractHandshaker.class);
    private static final HttpField SERVER_VERSION = new PreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);

    @Override
    public boolean upgradeRequest(WebSocketNegotiator negotiator, Request request, Response response, Callback callback, WebSocketComponents components, Configuration.Customizer defaultCustomizer) throws WebSocketException {
        if (!this.isWebSocketUpgradeRequest(request)) {
            return false;
        }
        WebSocketNegotiation negotiation = this.newNegotiation(request, response, callback, components);
        if (LOG.isDebugEnabled()) {
            LOG.debug("negotiation {}", (Object)negotiation);
        }
        negotiation.negotiate();
        if (!this.validateNegotiation(negotiation)) {
            return false;
        }
        FrameHandler handler = negotiator.negotiate(negotiation.getRequest(), negotiation.getResponse(), negotiation.getCallback());
        if (handler == null) {
            return true;
        }
        String protocol = negotiation.getSubprotocol();
        List<String> offeredProtocols = negotiation.getOfferedSubprotocols();
        if (protocol != null) {
            if (!offeredProtocols.contains(protocol)) {
                throw new WebSocketException("not upgraded: selected a protocol not present in offered protocols");
            }
            response.getHeaders().put(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, protocol);
        }
        for (ExtensionConfig config : negotiation.getNegotiatedExtensions()) {
            if (config.getName().startsWith("@")) continue;
            long matches = negotiation.getOfferedExtensions().stream().filter(c -> config.getName().equalsIgnoreCase(c.getName())).count();
            if (matches < 1L) {
                throw new WebSocketException("Upgrade failed: negotiated extension not requested");
            }
            matches = negotiation.getNegotiatedExtensions().stream().filter(c -> config.getName().equalsIgnoreCase(c.getName())).count();
            if (matches <= 1L) continue;
            throw new WebSocketException("Upgrade failed: multiple negotiated extensions of the same name");
        }
        ExtensionStack extensionStack = new ExtensionStack(components, Behavior.SERVER);
        extensionStack.negotiate(negotiation.getOfferedExtensions(), negotiation.getNegotiatedExtensions());
        negotiation.setNegotiatedExtensions(extensionStack.getNegotiatedExtensions());
        if (extensionStack.hasNegotiatedExtensions()) {
            response.getHeaders().put(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, ExtensionConfig.toHeaderValue(negotiation.getNegotiatedExtensions()));
        } else {
            response.getHeaders().put(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, (String)null);
        }
        Negotiated negotiated = new Negotiated(request.getHttpURI().toURI(), protocol, request.isSecure(), extensionStack, WebSocketConstants.SPEC_VERSION_STRING);
        WebSocketCoreSession coreSession = this.newWebSocketCoreSession(request, handler, negotiated, components);
        if (defaultCustomizer != null) {
            defaultCustomizer.customize(coreSession);
        }
        negotiator.customize(coreSession);
        if (LOG.isDebugEnabled()) {
            LOG.debug("session {}", (Object)coreSession);
        }
        WebSocketConnection connection = this.createWebSocketConnection(request, coreSession);
        if (LOG.isDebugEnabled()) {
            LOG.debug("connection {}", (Object)connection);
        }
        if (connection == null) {
            throw new WebSocketException("not upgraded: no connection");
        }
        ConnectionMetaData connectionMetaData = request.getConnectionMetaData();
        HttpConfiguration httpConfig = connectionMetaData.getHttpConfiguration();
        connection.setUseInputDirectByteBuffers(httpConfig.isUseInputDirectByteBuffers());
        connection.setUseOutputDirectByteBuffers(httpConfig.isUseOutputDirectByteBuffers());
        connectionMetaData.getConnector().getEventListeners().forEach(connection::addEventListener);
        this.prepareResponse(response, negotiation);
        request.setAttribute(HttpStream.UPGRADE_CONNECTION_ATTRIBUTE, connection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("upgrade connection={} session={} framehandler={}", connection, coreSession, handler);
        }
        response.write(true, null, callback);
        return true;
    }

    protected abstract WebSocketNegotiation newNegotiation(Request var1, Response var2, Callback var3, WebSocketComponents var4);

    @Override
    public boolean isWebSocketUpgradeRequest(Request request) {
        String wsVersionHeader = request.getHeaders().get(HttpHeader.SEC_WEBSOCKET_VERSION);
        if (!WebSocketConstants.SPEC_VERSION_STRING.equals(wsVersionHeader)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded: unsupported version {} {}", (Object)wsVersionHeader, (Object)request);
            }
            return false;
        }
        return true;
    }

    protected boolean validateNegotiation(WebSocketNegotiation negotiation) {
        if (!negotiation.validateHeaders()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded: no upgrade header or connection upgrade {}", (Object)negotiation.getRequest());
            }
            return false;
        }
        return true;
    }

    protected WebSocketCoreSession newWebSocketCoreSession(Request request, FrameHandler handler, Negotiated negotiated, WebSocketComponents components) {
        final Context context = request.getContext();
        return new WebSocketCoreSession(handler, Behavior.SERVER, negotiated, components){

            @Override
            protected void handle(Runnable runnable) {
                context.run(runnable);
            }
        };
    }

    protected abstract WebSocketConnection createWebSocketConnection(Request var1, WebSocketCoreSession var2);

    protected WebSocketConnection newWebSocketConnection(EndPoint endPoint, Executor executor, Scheduler scheduler, ByteBufferPool byteBufferPool, WebSocketCoreSession coreSession) {
        WebSocketConnection connection = new WebSocketConnection(endPoint, executor, scheduler, byteBufferPool, coreSession);
        coreSession.setWebSocketConnection(connection);
        return connection;
    }

    protected abstract void prepareResponse(Response var1, WebSocketNegotiation var2);
}

