/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Resource
implements Iterable<Resource> {
    private static final Logger LOG = LoggerFactory.getLogger(Resource.class);
    private static final LinkOption[] NO_FOLLOW_LINKS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    public static String dump(Resource resource) {
        if (resource == null) {
            return "null exists=false directory=false lm=-1";
        }
        return "%s exists=%b directory=%b lm=%s".formatted(resource.toString(), resource.exists(), resource.isDirectory(), resource.lastModified());
    }

    public abstract Path getPath();

    public boolean isContainedIn(Resource container) {
        return container != null && container.contains(this);
    }

    public boolean contains(Resource other) {
        if (other == null) {
            return false;
        }
        URI thisURI = this.getURI();
        if (thisURI == null) {
            throw new UnsupportedOperationException("Resources without a URI must implement contains");
        }
        URI otherURI = other.getURI();
        if (otherURI == null) {
            return false;
        }
        if (!StringUtil.asciiEqualsIgnoreCase(thisURI.getScheme(), otherURI.getScheme())) {
            return false;
        }
        if (!Objects.equals(thisURI.getAuthority(), otherURI.getAuthority())) {
            return false;
        }
        String thisURIString = URIUtil.correctURI(thisURI).toASCIIString();
        String otherURIString = URIUtil.correctURI(otherURI).toASCIIString();
        return otherURIString.startsWith(thisURIString) && (thisURIString.length() == otherURIString.length() || otherURIString.charAt(thisURIString.length()) == '/');
    }

    public Path getPathTo(Resource other) {
        Path thisPath = this.getPath();
        if (thisPath == null) {
            throw new UnsupportedOperationException("Resources without a Path must implement getPathTo");
        }
        if (!this.contains(other)) {
            return null;
        }
        Path otherPath = other.getPath();
        if (otherPath == null) {
            return null;
        }
        return thisPath.relativize(otherPath);
    }

    @Override
    public Iterator<Resource> iterator() {
        return List.of(this).iterator();
    }

    public boolean exists() {
        return Files.exists(this.getPath(), NO_FOLLOW_LINKS);
    }

    public abstract boolean isDirectory();

    public abstract boolean isReadable();

    public Instant lastModified() {
        return Instant.EPOCH;
    }

    public long length() {
        return -1L;
    }

    public abstract URI getURI();

    public abstract String getName();

    public abstract String getFileName();

    public InputStream newInputStream() throws IOException {
        Path path = this.getPath();
        if (path == null) {
            return null;
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    @Deprecated(since="12.0.8", forRemoval=true)
    public ReadableByteChannel newReadableByteChannel() throws IOException {
        Path path = this.getPath();
        if (path == null) {
            return null;
        }
        return Files.newByteChannel(this.getPath(), StandardOpenOption.READ);
    }

    public List<Resource> list() {
        return List.of();
    }

    public abstract Resource resolve(String var1);

    public boolean isAlias() {
        return false;
    }

    public URI getRealURI() {
        return this.getURI();
    }

    public void copyTo(Path destination) throws IOException {
        if (!this.exists()) {
            throw new IOException("Resource does not exist: " + this.getFileName());
        }
        Path src = this.getPath();
        if (src == null) {
            if (this.isDirectory()) {
                throw new UnsupportedOperationException("Directory Resources without a Path must implement copyTo: " + this);
            }
            String filename = this.getFileName();
            if (StringUtil.isBlank(filename)) {
                throw new UnsupportedOperationException("File Resources without a Path must implement getFileName: " + this);
            }
            Path destFile = destination;
            if (Files.isDirectory(destFile, new LinkOption[0])) {
                destFile = destFile.resolve(filename);
            }
            try (InputStream in = this.newInputStream();
                 OutputStream out = Files.newOutputStream(destFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                IO.copy(in, out);
            }
            return;
        }
        if (Files.isRegularFile(src, new LinkOption[0])) {
            if (Files.isDirectory(destination, new LinkOption[0])) {
                Path destPath = destination.resolve(src.getFileName().toString());
                IO.copyFile(src, destPath);
            } else {
                IO.copyFile(src, destination);
            }
            return;
        }
        assert (this.isDirectory());
        IO.copyDir(src, destination);
    }

    public Collection<Resource> getAllResources() {
        try {
            List<Resource> children = this.list();
            if (children == null || children.isEmpty()) {
                return List.of();
            }
            boolean noDepth = true;
            Iterator<Resource> i = children.iterator();
            while (noDepth && i.hasNext()) {
                Path resourcePath;
                Resource resource = i.next();
                if (!resource.isDirectory() || (resourcePath = resource.getPath()) != null && Files.isSymbolicLink(resourcePath)) continue;
                noDepth = false;
            }
            if (noDepth) {
                return children;
            }
            ArrayList<Resource> deep = new ArrayList<Resource>();
            for (Resource r : children) {
                deep.add(r);
                if (!r.isDirectory()) continue;
                deep.addAll(r.getAllResources());
            }
            return deep;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isSameFile(Path path) {
        block4: {
            Path resourcePath = this.getPath();
            if (Objects.equals(path, resourcePath)) {
                return true;
            }
            try {
                if (Files.isSameFile(path, resourcePath)) {
                    return true;
                }
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("ignored", t);
            }
        }
        return false;
    }

    public String toString() {
        String str = this.getName();
        URI uri = this.getURI();
        if (uri != null) {
            str = this.getURI().toASCIIString();
        }
        return "(" + TypeUtil.toShortName(this.getClass()) + ") " + str;
    }
}

