/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.Invocable;

public class EchoHandler
extends Handler.Abstract {
    @Override
    public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.BLOCKING;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) {
        response.setStatus(200);
        long contentLength = -1L;
        for (HttpField field : request.getHeaders()) {
            if (field.getHeader() == null) continue;
            switch (field.getHeader()) {
                case CONTENT_LENGTH: {
                    response.getHeaders().add(field);
                    contentLength = field.getLongValue();
                    break;
                }
                case CONTENT_TYPE: {
                    response.getHeaders().add(field);
                    break;
                }
                case TRAILER: {
                    response.setTrailersSupplier(HttpFields.build());
                    break;
                }
                case TRANSFER_ENCODING: {
                    contentLength = Long.MAX_VALUE;
                }
            }
        }
        if (contentLength > 0L) {
            this.copy(request, response, callback);
        } else {
            callback.succeeded();
        }
        return true;
    }

    protected void copy(Request request, Response response, Callback callback) {
        Content.copy(request, response, Response.newTrailersChunkProcessor(response), callback);
    }

    public static class BufferedAsync
    extends EchoHandler {
        @Override
        protected void copy(Request request, final Response response, final Callback callback) {
            Content.Source.asByteBuffer(request, new Promise<ByteBuffer>(){

                @Override
                public void succeeded(ByteBuffer result) {
                    response.write(true, result, callback);
                }

                @Override
                public void failed(Throwable x) {
                    callback.failed(x);
                }
            });
        }
    }

    public static class Buffered
    extends EchoHandler {
        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.BLOCKING;
        }

        @Override
        protected void copy(Request request, Response response, Callback callback) {
            try {
                response.write(true, Content.Source.asByteBuffer(request), callback);
            }
            catch (IOException e) {
                callback.failed(e);
            }
        }
    }

    public static class Stream
    extends EchoHandler {
        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.BLOCKING;
        }

        @Override
        protected void copy(Request request, Response response, Callback callback) {
            try {
                IO.copy(Content.Source.asInputStream(request), Content.Sink.asOutputStream(response));
                callback.succeeded();
            }
            catch (IOException e) {
                callback.failed(e);
            }
        }
    }

    public static class Reactive
    extends EchoHandler {
        @Override
        protected void copy(Request request, Response response, Callback callback) {
            Content.Source.asPublisher(request).subscribe(Content.Sink.asSubscriber(response, callback));
        }
    }
}

