/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.eclipse.jetty.util.Pool;

public class QueuedPool<P>
implements Pool<P> {
    private final int maxSize;
    private final Queue<Pool.Entry<P>> queue = new ConcurrentLinkedQueue<Pool.Entry<P>>();
    private final AtomicInteger queueSize = new AtomicInteger();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean terminated;

    public QueuedPool(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public Pool.Entry<P> reserve() {
        this.rwLock.readLock().lock();
        try {
            if (this.terminated || this.queueSize.get() == this.maxSize) {
                Pool.Entry<P> entry = null;
                return entry;
            }
            QueuedEntry queuedEntry = new QueuedEntry(this);
            return queuedEntry;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requeue(Pool.Entry<P> entry) {
        this.rwLock.readLock().lock();
        try {
            int size;
            do {
                size = this.queueSize.get();
                if (!this.terminated && size != this.maxSize) continue;
                boolean bl = false;
                return bl;
            } while (!this.queueSize.compareAndSet(size, size + 1));
            this.queue.add(entry);
            boolean bl = true;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public Pool.Entry<P> acquire() {
        this.rwLock.readLock().lock();
        try {
            if (this.terminated) {
                Pool.Entry<P> entry = null;
                return entry;
            }
            QueuedEntry entry = (QueuedEntry)this.queue.poll();
            if (entry != null) {
                this.queueSize.decrementAndGet();
                entry.acquire();
            }
            QueuedEntry queuedEntry = entry;
            return queuedEntry;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public boolean isTerminated() {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.terminated;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public Collection<Pool.Entry<P>> terminate() {
        this.rwLock.writeLock().lock();
        try {
            this.terminated = true;
            ArrayList<Pool.Entry<P>> copy = new ArrayList<Pool.Entry<P>>(this.queue);
            this.queue.clear();
            this.queueSize.set(0);
            ArrayList<Pool.Entry<P>> arrayList = copy;
            return arrayList;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        return this.queueSize.get();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public Stream<Pool.Entry<P>> stream() {
        return this.queue.stream();
    }

    @Override
    public int getReservedCount() {
        return 0;
    }

    @Override
    public int getIdleCount() {
        return this.size();
    }

    @Override
    public int getInUseCount() {
        return 0;
    }

    @Override
    public int getTerminatedCount() {
        return 0;
    }

    private static class QueuedEntry<P>
    implements Pool.Entry<P> {
        private final QueuedPool<P> pool;
        private final AtomicMarkableReference<P> pooled = new AtomicMarkableReference<Object>(null, false);

        private QueuedEntry(QueuedPool<P> pool) {
            this.pool = pool;
        }

        @Override
        public boolean enable(P pooled, boolean acquire) {
            Objects.requireNonNull(pooled);
            boolean[] state = new boolean[1];
            do {
                P p;
                if ((p = this.pooled.get(state)) != null) {
                    if (this.pool.isTerminated()) {
                        return false;
                    }
                    throw new IllegalStateException("Entry already enabled " + this + " for " + this.pool);
                }
                if (!state[0]) continue;
                return false;
            } while (!this.pooled.compareAndSet(null, pooled, false, acquire));
            if (acquire) {
                if (this.pool.isTerminated()) {
                    this.pooled.set(null, true);
                    return false;
                }
                return true;
            }
            return this.pool.requeue(this);
        }

        @Override
        public P getPooled() {
            return this.pooled.getReference();
        }

        void acquire() {
            P p;
            boolean[] state = new boolean[1];
            do {
                boolean idle;
                if (idle = QueuedEntry.isIdle(p = this.pooled.get(state), state[0])) continue;
                return;
            } while (!this.pooled.compareAndSet(p, p, false, true));
        }

        @Override
        public boolean release() {
            P p;
            boolean[] state = new boolean[1];
            do {
                boolean inUse;
                if (inUse = QueuedEntry.isInUse(p = this.pooled.get(state), state[0])) continue;
                return false;
            } while (!this.pooled.compareAndSet(p, p, true, false));
            return this.pool.requeue(this);
        }

        @Override
        public boolean remove() {
            P p;
            boolean[] state = new boolean[1];
            do {
                boolean terminated;
                if (!(terminated = QueuedEntry.isTerminated(p = this.pooled.get(state), state[0]))) continue;
                return false;
            } while (!this.pooled.compareAndSet(p, null, state[0], true));
            return true;
        }

        @Override
        public boolean isReserved() {
            boolean[] state = new boolean[1];
            P p = this.pooled.get(state);
            return QueuedEntry.isReserved(p, state[0]);
        }

        private static boolean isReserved(Object item, boolean state) {
            return item == null && !state;
        }

        @Override
        public boolean isIdle() {
            boolean[] state = new boolean[1];
            P p = this.pooled.get(state);
            return QueuedEntry.isIdle(p, state[0]);
        }

        private static boolean isIdle(Object item, boolean state) {
            return item != null && !state;
        }

        @Override
        public boolean isInUse() {
            boolean[] state = new boolean[1];
            P p = this.pooled.get(state);
            return QueuedEntry.isInUse(p, state[0]);
        }

        private static boolean isInUse(Object item, boolean state) {
            return item != null && state;
        }

        @Override
        public boolean isTerminated() {
            boolean[] state = new boolean[1];
            P p = this.pooled.get(state);
            return QueuedEntry.isTerminated(p, state[0]);
        }

        private static boolean isTerminated(Object item, boolean state) {
            return item == null && state;
        }
    }
}

