/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class ChunksContentSource
implements Content.Source {
    private final AutoLock lock = new AutoLock();
    private final SerializedInvoker invoker = new SerializedInvoker(ChunksContentSource.class);
    private final long length;
    private final Collection<Content.Chunk> chunks;
    private Iterator<Content.Chunk> iterator;
    private Content.Chunk terminated;
    private Runnable demandCallback;

    public ChunksContentSource(Collection<Content.Chunk> chunks) {
        long sum = 0L;
        Iterator<Content.Chunk> it = chunks.iterator();
        while (it.hasNext()) {
            Content.Chunk chunk = it.next();
            if (chunk == null) continue;
            if (it.hasNext() && chunk.isLast()) {
                throw new IllegalArgumentException("Collection cannot contain a last Content.Chunk that is not at the last position: " + chunk);
            }
            sum += (long)chunk.getByteBuffer().remaining();
        }
        chunks.stream().filter(Objects::nonNull).forEach(Retainable::retain);
        this.chunks = chunks;
        this.length = sum;
    }

    public Collection<Content.Chunk> getChunks() {
        return this.chunks;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Content.Chunk read() {
        Content.Chunk chunk;
        try (AutoLock ignored = this.lock.lock();){
            if (this.terminated != null) {
                Content.Chunk chunk2 = this.terminated;
                return chunk2;
            }
            if (this.iterator == null) {
                this.iterator = this.chunks.iterator();
            }
            if ((chunk = this.iterator.next()) != null && chunk.isLast()) {
                this.terminated = Content.Chunk.next(chunk);
            }
            if (this.terminated == null && !this.iterator.hasNext()) {
                this.terminated = Content.Chunk.EOF;
            }
        }
        return chunk;
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this.invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            ExceptionUtil.run(demandCallback, this::fail);
        }
    }

    @Override
    public void fail(Throwable failure) {
        List<Object> chunksToRelease;
        try (AutoLock ignored = this.lock.lock();){
            if (this.terminated != null) {
                return;
            }
            this.terminated = Content.Chunk.from(failure);
            if (this.iterator != null) {
                chunksToRelease = new ArrayList();
                this.iterator.forEachRemaining(chunksToRelease::add);
            } else {
                chunksToRelease = List.copyOf(this.chunks);
            }
        }
        chunksToRelease.stream().filter(Objects::nonNull).forEach(Retainable::release);
    }
}

