/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedContentSink
implements Content.Sink {
    public static final ByteBuffer FLUSH_BUFFER = ByteBuffer.wrap(new byte[0]);
    private static final Logger LOG = LoggerFactory.getLogger(BufferedContentSink.class);
    private final Content.Sink _delegate;
    private final RetainableByteBuffer.DynamicCapacity _aggregator;
    private final SerializedInvoker _serializer = new SerializedInvoker(BufferedContentSink.class);
    private boolean _firstWrite = true;
    private boolean _lastWritten;

    public BufferedContentSink(Content.Sink delegate, ByteBufferPool bufferPool, boolean direct, int maxAggregationSize, int maxBufferSize) {
        this(delegate, new ByteBufferPool.Sized(bufferPool, direct, maxAggregationSize), maxBufferSize);
    }

    public BufferedContentSink(Content.Sink delegate, ByteBufferPool.Sized sizedPool, int maxBufferSize) {
        if (maxBufferSize <= 0) {
            throw new IllegalArgumentException("maxBufferSize must be > 0, was: " + maxBufferSize);
        }
        if (sizedPool.getSize() <= 0) {
            throw new IllegalArgumentException("pool.size must be > 0, was: " + sizedPool.getSize());
        }
        if (maxBufferSize < sizedPool.getSize()) {
            throw new IllegalArgumentException("maxBufferSize (" + maxBufferSize + ") must be >= pool.size (" + sizedPool.getSize() + ")");
        }
        this._delegate = delegate;
        this._aggregator = new RetainableByteBuffer.DynamicCapacity(sizedPool, maxBufferSize);
    }

    @Override
    public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
        ByteBuffer current;
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing last={} {}", (Object)last, (Object)BufferUtil.toDetailString(byteBuffer));
        }
        if (this._lastWritten) {
            callback.failed(new IOException("complete"));
            return;
        }
        this._lastWritten = last;
        if (this._firstWrite) {
            this._firstWrite = false;
            if (last) {
                this._delegate.write(true, byteBuffer, callback);
                return;
            }
        }
        ByteBuffer byteBuffer2 = current = byteBuffer != null ? byteBuffer : BufferUtil.EMPTY_BUFFER;
        if (current.remaining() <= this._aggregator.getAggregationSize() && !last && byteBuffer != FLUSH_BUFFER) {
            this.aggregateAndFlush(current, callback);
        } else {
            this.flush(last, current, callback);
        }
    }

    public void flush(Callback callback) {
        this.flush(false, FLUSH_BUFFER, callback);
    }

    private void flush(final boolean last, final ByteBuffer currentBuffer, final Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("given buffer is greater than _maxBufferSize");
        }
        if (this._aggregator.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("nothing aggregated, flushing current buffer {}", (Object)currentBuffer);
            }
            this._delegate.write(last, currentBuffer, callback);
        } else if (!currentBuffer.hasRemaining()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushing aggregate {}", (Object)this._aggregator);
            }
            this._aggregator.writeTo(this._delegate, last, callback);
        } else if (last && (long)currentBuffer.remaining() <= Math.min((long)this._aggregator.getAggregationSize(), this._aggregator.space()) && this._aggregator.append(currentBuffer)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushing aggregated {}", (Object)this._aggregator);
            }
            this._aggregator.writeTo(this._delegate, true, callback);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushing aggregate {} and buffer {}", (Object)this._aggregator, (Object)currentBuffer);
            }
            this._aggregator.writeTo(this._delegate, false, new Callback(){

                @Override
                public void succeeded() {
                    BufferedContentSink.this._delegate.write(last, currentBuffer, callback);
                }

                @Override
                public void failed(Throwable x) {
                    callback.failed(x);
                }

                @Override
                public Invocable.InvocationType getInvocationType() {
                    return callback.getInvocationType();
                }
            });
        }
    }

    private void aggregateAndFlush(final ByteBuffer currentBuffer, final Callback callback) {
        if (this._aggregator.append(currentBuffer)) {
            this._serializer.run(callback::succeeded);
            return;
        }
        this._aggregator.writeTo(this._delegate, false, new Callback(){

            @Override
            public void succeeded() {
                if (BufferedContentSink.this._aggregator.append(currentBuffer)) {
                    callback.succeeded();
                } else {
                    callback.failed(new BufferOverflowException());
                }
            }

            @Override
            public void failed(Throwable x) {
                callback.failed(x);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return callback.getInvocationType();
            }
        });
    }
}

