/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.SetCookieParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFC6265SetCookieParser
implements SetCookieParser {
    private static final Logger LOG = LoggerFactory.getLogger(RFC6265SetCookieParser.class);

    @Override
    public HttpCookie parse(String setCookieValue) {
        State state = State.NAME;
        String name = null;
        boolean quoted = false;
        HttpCookie.Builder cookie = null;
        int offset = 0;
        int length = setCookieValue.length();
        block18: for (int i = 0; i < length; ++i) {
            char ch = setCookieValue.charAt(i);
            switch (state) {
                case NAME: {
                    HttpTokens.Token token = HttpTokens.getToken(ch);
                    if (token == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("invalid character {} at index {} of {}", Character.valueOf(ch), i, setCookieValue);
                        }
                        return null;
                    }
                    if (ch != '=') continue block18;
                    name = setCookieValue.substring(offset, i).trim();
                    if (name.isEmpty()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("invalid empty cookie name at index {} of {}", (Object)i, (Object)setCookieValue);
                        }
                        return null;
                    }
                    offset = i + 1;
                    state = State.VALUE_START;
                    continue block18;
                }
                case VALUE_START: {
                    if (RFC6265SetCookieParser.isWhitespace(ch)) continue block18;
                    if (ch == '\"') {
                        quoted = true;
                    } else {
                        --i;
                    }
                    offset = i + 1;
                    state = State.VALUE;
                    continue block18;
                }
                case VALUE: {
                    String value;
                    if (quoted && ch == '\"') {
                        quoted = false;
                        value = setCookieValue.substring(offset, i).trim();
                        cookie = HttpCookie.build(name, value);
                        offset = i + 1;
                        state = State.ATTRIBUTE;
                        continue block18;
                    }
                    if (ch != ';') continue block18;
                    value = setCookieValue.substring(offset, i).trim();
                    cookie = HttpCookie.build(name, value);
                    offset = i + 1;
                    state = State.ATTRIBUTE_NAME;
                    continue block18;
                }
                case ATTRIBUTE: {
                    if (RFC6265SetCookieParser.isWhitespace(ch)) continue block18;
                    if (ch != ';') {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("invalid character {} at index {} of {}", Character.valueOf(ch), i, setCookieValue);
                        }
                        return null;
                    }
                    offset = i + 1;
                    state = State.ATTRIBUTE_NAME;
                    continue block18;
                }
                case ATTRIBUTE_NAME: {
                    HttpTokens.Token token = HttpTokens.getToken(ch);
                    if (token == null || token.getType() == HttpTokens.Type.CNTL) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("invalid character {} at index {} of {}", Character.valueOf(ch), i, setCookieValue);
                        }
                        return null;
                    }
                    if (ch == '=') {
                        name = setCookieValue.substring(offset, i).trim();
                        offset = i + 1;
                        state = State.ATTRIBUTE_VALUE_START;
                        continue block18;
                    }
                    if (ch != ';') continue block18;
                    name = setCookieValue.substring(offset, i).trim();
                    if (!this.setAttribute(cookie, name, "")) {
                        return null;
                    }
                    offset = i + 1;
                    continue block18;
                }
                case ATTRIBUTE_VALUE_START: {
                    if (RFC6265SetCookieParser.isWhitespace(ch)) continue block18;
                    if (ch == '\"') {
                        quoted = true;
                    } else {
                        --i;
                    }
                    offset = i + 1;
                    state = State.ATTRIBUTE_VALUE;
                    continue block18;
                }
                case ATTRIBUTE_VALUE: {
                    String value;
                    if (quoted && ch == '\"') {
                        quoted = false;
                        value = setCookieValue.substring(offset, i).trim();
                        if (!this.setAttribute(cookie, name, value)) {
                            return null;
                        }
                        offset = i + 1;
                        state = State.ATTRIBUTE;
                        continue block18;
                    }
                    if (ch != ';') continue block18;
                    value = setCookieValue.substring(offset, i).trim();
                    if (!this.setAttribute(cookie, name, value)) {
                        return null;
                    }
                    offset = i + 1;
                    state = State.ATTRIBUTE_NAME;
                    continue block18;
                }
                default: {
                    throw new IllegalStateException("invalid state " + state);
                }
            }
        }
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case State.NAME -> null;
            case State.VALUE_START -> HttpCookie.from(name, "");
            case State.VALUE -> HttpCookie.from(name, setCookieValue.substring(offset, length).trim());
            case State.ATTRIBUTE -> cookie.build();
            case State.ATTRIBUTE_NAME -> {
                if (this.setAttribute(cookie, setCookieValue.substring(offset, length).trim(), "")) {
                    yield cookie.build();
                }
                yield null;
            }
            case State.ATTRIBUTE_VALUE_START -> {
                if (this.setAttribute(cookie, name, "")) {
                    yield cookie.build();
                }
                yield null;
            }
            case State.ATTRIBUTE_VALUE -> this.setAttribute(cookie, name, setCookieValue.substring(offset, length).trim()) ? cookie.build() : null;
        };
    }

    private static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    private boolean setAttribute(HttpCookie.Builder cookie, String name, String value) {
        try {
            cookie.attribute(name, value);
            return true;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("could not set attribute {}={}", name, value, x);
            }
            return false;
        }
    }

    private static enum State {
        NAME,
        VALUE_START,
        VALUE,
        ATTRIBUTE,
        ATTRIBUTE_NAME,
        ATTRIBUTE_VALUE_START,
        ATTRIBUTE_VALUE;

    }
}

