/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.expression.jexl;

import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.ExpressionSupport;
import org.apache.commons.jelly.expression.jexl.JexlExpression;

public class JexlExpressionFactory
implements ExpressionFactory {
    private boolean supportAntVariables = true;

    @Override
    public Expression createExpression(String text) throws JellyException {
        JexlExpression jexlExpression = null;
        try {
            jexlExpression = new JexlExpression(org.apache.commons.jexl.ExpressionFactory.createExpression((String)text));
        }
        catch (Exception e) {
            throw new JellyException("Unable to create expression: " + text, e);
        }
        if (this.isSupportAntVariables() && this.isValidAntVariableName(text)) {
            return new ExpressionSupportLocal(jexlExpression, text);
        }
        return jexlExpression;
    }

    public boolean isSupportAntVariables() {
        return this.supportAntVariables;
    }

    public void setSupportAntVariables(boolean supportAntVariables) {
        this.supportAntVariables = supportAntVariables;
    }

    protected boolean isValidAntVariableName(String text) {
        for (char ch : text.toCharArray()) {
            if (!Character.isWhitespace(ch) && ch != '[' && ch != ']' && ch != '(' && ch != ')') continue;
            return false;
        }
        return true;
    }

    private class ExpressionSupportLocal
    extends ExpressionSupport {
        protected Expression jexlExpression = null;
        protected String text = null;

        public ExpressionSupportLocal(Expression jexlExpression, String text) {
            this.jexlExpression = jexlExpression;
            this.text = text;
        }

        @Override
        public Object evaluate(JellyContext context) {
            Object answer = this.jexlExpression.evaluate(context);
            if (answer == null) {
                answer = context.getVariable(this.text);
            }
            return answer;
        }

        @Override
        public String getExpressionText() {
            return "${" + this.text + "}";
        }

        public String toString() {
            return super.toString() + "[expression:" + this.text + "]";
        }
    }
}

