/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.component.NamedEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Environment
extends Attributes {
    public static final Logger LOG = LoggerFactory.getLogger(Environment.class);

    public static Collection<Environment> getAll() {
        return Collections.unmodifiableCollection(NamedEnvironment.ENVIRONMENTS.values());
    }

    public static void removeAll() {
        NamedEnvironment.ENVIRONMENTS.clear();
    }

    public static Environment get(String name) {
        return NamedEnvironment.ENVIRONMENTS.get(name);
    }

    public static Environment ensure(String name, Class<?> classToLoad) throws IllegalStateException {
        ClassLoader loader = Objects.requireNonNull(classToLoad).getClassLoader() == null ? Environment.class.getClassLoader() : classToLoad.getClassLoader();
        Environment environment = NamedEnvironment.ENVIRONMENTS.computeIfAbsent(name, n -> new NamedEnvironment((String)n, loader));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Environment.ensure: {} {} {}", name, classToLoad, environment);
        }
        if (environment.getClassLoader() == loader) {
            return environment;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Environment.ensure: {} not same loader {} != {}", name, environment.getClassLoader(), loader);
        }
        try {
            Class<?> loadClass = environment.getClassLoader().loadClass(classToLoad.getName());
            if (loadClass == classToLoad) {
                return environment;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Environment.ensure: {} cannot load same class instance {} != {}", name, loadClass.getClassLoader(), classToLoad.getClassLoader());
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("%s has different classloader".formatted(name), e);
        }
        throw new IllegalArgumentException("%s has different classloader".formatted(name));
    }

    public static Environment create(String name, ClassLoader classLoader) throws IllegalStateException {
        return NamedEnvironment.ENVIRONMENTS.compute(name, (n, environment) -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Environment.create: {} {} {}", name, classLoader, environment);
            }
            if (environment != null) {
                throw new IllegalStateException("Environment already exists: " + n);
            }
            return new NamedEnvironment((String)n, classLoader);
        });
    }

    public String getName();

    public ClassLoader getClassLoader();

    default public void run(Runnable runnable) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        try {
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

