/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.details;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.Item;
import java.util.List;
import jenkins.model.details.Detail;

public class DownstreamProjectsDetail
extends Detail {
    public DownstreamProjectsDetail(Actionable object) {
        super(object);
    }

    @Override
    @Nullable
    public String getIconClassName() {
        if (this.getProjects().isEmpty()) {
            return null;
        }
        return "symbol-arrow-down-circle-outline plugin-ionicons-api";
    }

    @Override
    @Nullable
    public String getDisplayName() {
        int projectSize = this.getProjects().size();
        if (projectSize == 1) {
            return "1 downstream project";
        }
        return projectSize + " downstream projects";
    }

    public List<AbstractProject> getProjects() {
        if (!(this.getObject() instanceof AbstractProject)) {
            return List.of();
        }
        List<AbstractProject> projects = ((AbstractProject)this.getObject()).getDownstreamProjects();
        return projects.stream().filter(e -> e.hasPermission(Item.READ)).toList();
    }
}

