/*
 * Decompiled with CFR 0.152.
 */
package jenkins.diagnostics;

import hudson.Extension;
import hudson.Main;
import hudson.model.AdministrativeMonitor;
import java.io.IOException;
import jenkins.diagnostics.Messages;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"executorsOnBuiltInNodeWithAgents", "controllerExecutorsWithAgents"})
@Restricted(value={NoExternalUse.class})
public class ControllerExecutorsAgents
extends AdministrativeMonitor {
    @Override
    public String getDisplayName() {
        return Messages.ControllerExecutorsAgents_DisplayName();
    }

    @Override
    public boolean isSecurity() {
        return true;
    }

    @Override
    public boolean isActivated() {
        return !Main.isDevelopmentMode && Jenkins.get().getNumExecutors() > 0 && (!Jenkins.get().clouds.isEmpty() || !Jenkins.get().getNodes().isEmpty());
    }

    @RequirePOST
    public void doAct(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (req.hasParameter("no")) {
            this.disable(true);
            rsp.sendRedirect(req.getContextPath() + "/manage");
        } else if (req.hasParameter("yes")) {
            rsp.sendRedirect(req.getContextPath() + "/computer/(built-in)/configure");
        }
    }
}

