/*
 * Decompiled with CFR 0.152.
 */
package jenkins.agents;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import java.util.Date;
import java.util.Objects;
import jenkins.agents.Messages;

public interface IOfflineCause {
    @NonNull
    default public String getComputerIcon() {
        return "symbol-computer-offline";
    }

    @NonNull
    default public String getComputerIconAltText() {
        return "[offline]";
    }

    @NonNull
    default public String getIcon() {
        return "symbol-error";
    }

    @NonNull
    default public String getReason() {
        String gsub_base = hudson.slaves.Messages.SlaveComputer_DisconnectedBy("", "");
        String gsub1 = "^" + gsub_base + "[\\w\\W]* \\: ";
        String gsub2 = "^" + gsub_base + "[\\w\\W]*";
        return Objects.requireNonNull(Util.escape(this.toString().replaceAll(gsub1, "").replaceAll(gsub2, "")));
    }

    @NonNull
    default public String getMessage() {
        return Messages.IOfflineCause_offline();
    }

    default public String getStatusClass() {
        return "warning";
    }

    public long getTimestamp();

    @NonNull
    default public Date getTime() {
        return new Date(this.getTimestamp());
    }
}

