/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.util.AdaptedIterator;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class Iterators {
    public static <T> Iterator<T> empty() {
        return Collections.emptyIterator();
    }

    public static <T> Iterable<T> reverse(List<T> lst) {
        return () -> {
            final ListIterator itr = lst.listIterator(lst.size());
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return itr.hasPrevious();
                }

                @Override
                public T next() {
                    return itr.previous();
                }

                @Override
                public void remove() {
                    itr.remove();
                }
            };
        };
    }

    public static <T> Iterable<T> wrap(Iterable<T> base) {
        return () -> {
            final Iterator itr = base.iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return itr.hasNext();
                }

                @Override
                public T next() {
                    return itr.next();
                }

                @Override
                public void remove() {
                    itr.remove();
                }
            };
        };
    }

    public static List<Integer> sequence(final int start, int end, final int step) {
        final int size = (end - start) / step;
        if (size < 0) {
            throw new IllegalArgumentException("List size is negative");
        }
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                if (index < 0 || index >= size) {
                    throw new IndexOutOfBoundsException();
                }
                return start + index * step;
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static List<Integer> sequence(int start, int end) {
        return Iterators.sequence(start, end, 1);
    }

    public static List<Integer> reverseSequence(int start, int end, int step) {
        return Iterators.sequence(end - 1, start - 1, -step);
    }

    public static List<Integer> reverseSequence(int start, int end) {
        return Iterators.reverseSequence(start, end, 1);
    }

    public static <T> Iterator<T> cast(Iterator<? extends T> itr) {
        return itr;
    }

    public static <T> Iterable<T> cast(Iterable<? extends T> itr) {
        return itr;
    }

    public static <U, T extends U> Iterator<T> subType(Iterator<U> itr, final Class<T> type) {
        return new FilterIterator<U>(itr){

            @Override
            protected boolean filter(U u) {
                return type.isInstance(u);
            }
        };
    }

    public static <T> Iterator<T> readOnly(final Iterator<T> itr) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public T next() {
                return itr.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> removeNull(Iterator<T> itr) {
        return com.google.common.collect.Iterators.filter(itr, Objects::nonNull);
    }

    public static <T, U> Iterator<U> map(Iterator<T> itr, final Function<T, U> mapper) {
        return new AdaptedIterator<T, U>(itr){

            @Override
            protected U adapt(T item) {
                return mapper.apply(item);
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> sequence(Iterable<? extends T> ... iterables) {
        return () -> new FlattenIterator<T, Iterable<? extends T>>((Iterable)ImmutableList.copyOf((Object[])iterables)){

            @Override
            protected Iterator<T> expand(Iterable<? extends T> iterable) {
                return Iterators.cast(iterable).iterator();
            }
        };
    }

    public static <T> Iterator<T> removeDups(Iterator<T> iterator) {
        return new FilterIterator<T>(iterator){
            final Set<T> found = new HashSet();

            @Override
            protected boolean filter(T t) {
                return this.found.add(t);
            }
        };
    }

    public static <T> Iterable<T> removeDups(Iterable<T> base) {
        return () -> Iterators.removeDups(base.iterator());
    }

    @SafeVarargs
    public static <T> Iterator<T> sequence(Iterator<? extends T> ... iterators) {
        return com.google.common.collect.Iterators.concat((Iterator[])iterators);
    }

    public static <T> Iterator<T> limit(final Iterator<? extends T> base, final CountingPredicate<? super T> filter) {
        return new Iterator<T>(){
            private T next;
            private boolean end;
            private int index = 0;

            @Override
            public boolean hasNext() {
                this.fetch();
                return this.next != null;
            }

            @Override
            public T next() {
                this.fetch();
                Object r = this.next;
                this.next = null;
                return r;
            }

            private void fetch() {
                if (this.next == null && !this.end) {
                    if (base.hasNext()) {
                        this.next = base.next();
                        if (!filter.apply(this.index++, this.next)) {
                            this.next = null;
                            this.end = true;
                        }
                    } else {
                        this.end = true;
                    }
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Restricted(value={NoExternalUse.class})
    public static void skip(@NonNull Iterator<?> iterator, int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        while (iterator.hasNext() && count-- > 0) {
            iterator.next();
        }
    }

    public static interface CountingPredicate<T> {
        public boolean apply(int var1, T var2);
    }

    public static final class DuplicateFilterIterator<T>
    extends FilterIterator<T> {
        private final Set<T> seen = new HashSet<T>();

        public DuplicateFilterIterator(Iterator<? extends T> core) {
            super(core);
        }

        public DuplicateFilterIterator(Iterable<? extends T> core) {
            super(core);
        }

        @Override
        protected boolean filter(T t) {
            return this.seen.add(t);
        }
    }

    public static abstract class FilterIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> core;
        private T next;
        private boolean fetched;

        protected FilterIterator(Iterator<? extends T> core) {
            this.core = core;
        }

        protected FilterIterator(Iterable<? extends T> core) {
            this(core.iterator());
        }

        private void fetch() {
            while (!this.fetched && this.core.hasNext()) {
                T n = this.core.next();
                if (!this.filter(n)) continue;
                this.next = n;
                this.fetched = true;
            }
        }

        protected abstract boolean filter(T var1);

        @Override
        public boolean hasNext() {
            this.fetch();
            return this.fetched;
        }

        @Override
        public T next() {
            this.fetch();
            if (!this.fetched) {
                throw new NoSuchElementException();
            }
            this.fetched = false;
            return this.next;
        }

        @Override
        public void remove() {
            this.core.remove();
        }
    }

    public static abstract class FlattenIterator<U, T>
    implements Iterator<U> {
        private final Iterator<? extends T> core;
        private Iterator<U> cur;

        protected FlattenIterator(Iterator<? extends T> core) {
            this.core = core;
            this.cur = Collections.emptyIterator();
        }

        protected FlattenIterator(Iterable<? extends T> core) {
            this(core.iterator());
        }

        protected abstract Iterator<U> expand(T var1);

        @Override
        public boolean hasNext() {
            while (!this.cur.hasNext()) {
                if (!this.core.hasNext()) {
                    return false;
                }
                this.cur = this.expand(this.core.next());
            }
            return true;
        }

        @Override
        public U next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.cur.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

