/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.node_monitors.AbstractDiskSpaceMonitor;
import hudson.node_monitors.DiskSpaceMonitorDescriptor;
import hudson.node_monitors.DiskSpaceMonitorNodeProperty;
import hudson.node_monitors.Messages;
import hudson.remoting.Callable;
import java.io.IOException;
import java.text.ParseException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class DiskSpaceMonitor
extends AbstractDiskSpaceMonitor {
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="for backward compatibility")
    public static DiskSpaceMonitorDescriptor DESCRIPTOR;

    @DataBoundConstructor
    public DiskSpaceMonitor(String freeSpaceThreshold) throws ParseException {
        super(freeSpaceThreshold);
    }

    public DiskSpaceMonitor() {
    }

    @Override
    public long getThresholdBytes(Computer c) {
        DiskSpaceMonitorNodeProperty nodeProperty;
        Node node = c.getNode();
        if (node != null && (nodeProperty = node.getNodeProperty(DiskSpaceMonitorNodeProperty.class)) != null) {
            try {
                return DiskSpaceMonitorDescriptor.DiskSpace.parse((String)nodeProperty.getFreeDiskSpaceThreshold()).size;
            }
            catch (ParseException e) {
                return this.getThresholdBytes();
            }
        }
        return this.getThresholdBytes();
    }

    @Override
    protected long getWarningThresholdBytes(Computer c) {
        DiskSpaceMonitorNodeProperty nodeProperty;
        Node node = c.getNode();
        if (node != null && (nodeProperty = node.getNodeProperty(DiskSpaceMonitorNodeProperty.class)) != null) {
            try {
                return DiskSpaceMonitorDescriptor.DiskSpace.parse((String)nodeProperty.getFreeDiskSpaceWarningThreshold()).size;
            }
            catch (ParseException e) {
                return this.getWarningThresholdBytes();
            }
        }
        return this.getWarningThresholdBytes();
    }

    public DiskSpaceMonitorDescriptor.DiskSpace getFreeSpace(Computer c) {
        return (DiskSpaceMonitorDescriptor.DiskSpace)DESCRIPTOR.get(c);
    }

    @Override
    public String getColumnCaption() {
        return Jenkins.get().hasPermission(Jenkins.ADMINISTER) ? super.getColumnCaption() : null;
    }

    @Extension
    @Symbol(value={"diskSpace"})
    public static class DescriptorImpl
    extends DiskSpaceMonitorDescriptor {
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="for backward compatibility")
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.DiskSpaceMonitor_DisplayName();
        }

        @Override
        protected Callable<DiskSpaceMonitorDescriptor.DiskSpace, IOException> createCallable(Computer c) {
            Node node = c.getNode();
            if (node == null) {
                return null;
            }
            FilePath p = node.getRootPath();
            if (p == null) {
                return null;
            }
            return p.asCallableWith(new DiskSpaceMonitorDescriptor.GetUsableSpace());
        }
    }
}

