/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting;

import io.jenkins.remoting.shaded.org.kohsuke.args4j.CmdLineException;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.CmdLineParser;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.OptionDef;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.spi.OptionHandler;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.spi.Parameters;
import io.jenkins.remoting.shaded.org.kohsuke.args4j.spi.Setter;
import java.time.Duration;
import org.jenkinsci.remoting.util.DurationFormatter;
import org.jenkinsci.remoting.util.DurationStyle;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DurationOptionHandler
extends OptionHandler<Duration> {
    public DurationOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Duration> setter) {
        super(parser, option, setter);
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        this.setter.addValue(DurationStyle.detectAndParse(params.getParameter(0)));
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        return "DURATION";
    }

    @Override
    protected String print(Duration v) {
        return DurationFormatter.format(v);
    }
}

