/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.filters;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.util.PropertyFilter;

public abstract class MappingPropertyFilter
implements PropertyFilter {
    private Map filters = new HashMap();

    public MappingPropertyFilter() {
        this(null);
    }

    public MappingPropertyFilter(Map filters) {
        if (filters != null) {
            Iterator iterator = filters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                Object key = entry.getKey();
                Object filter = entry.getValue();
                if (!(filter instanceof PropertyFilter)) continue;
                this.filters.put(key, filter);
            }
        }
    }

    public void addPropertyFilter(Object target, PropertyFilter filter) {
        if (filter != null) {
            this.filters.put(target, filter);
        }
    }

    @Override
    public boolean apply(Object source, String name, Object value) {
        for (Map.Entry o : this.filters.entrySet()) {
            Map.Entry entry = o;
            Object key = entry.getKey();
            if (!this.keyMatches(key, source, name, value)) continue;
            PropertyFilter filter = (PropertyFilter)entry.getValue();
            return filter.apply(source, name, value);
        }
        return false;
    }

    public void removePropertyFilter(Object target) {
        if (target != null) {
            this.filters.remove(target);
        }
    }

    protected abstract boolean keyMatches(Object var1, Object var2, String var3, Object var4);
}

