/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.bind;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.Bound;
import org.kohsuke.stapler.bind.WithWellKnownURL;

public class BoundObjectTable
implements StaplerFallback {
    private static final long EXPIRATION_TIME = Long.getLong(BoundObjectTable.class.getName() + ".EXPIRATION_TIME", Duration.ofDays(1L).toMillis());
    public static final String PREFIX = "/$stapler/bound/";
    static final String SCRIPT_PREFIX = "/$stapler/bound/script";
    private static final Logger LOGGER = Logger.getLogger(BoundObjectTable.class.getName());

    public static boolean isValidJavaScriptIdentifier(String variableName) {
        return variableName.matches("^[a-zA-Z_][a-zA-Z0-9_]*$");
    }

    public static boolean isValidJavaIdentifier(String name) {
        if (name == null || name.isBlank()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0)) || Character.codePointAt(name, 0) > 255) {
            return false;
        }
        return name.substring(1).chars().allMatch(it -> Character.isJavaIdentifierPart(it) && !Character.isIdentifierIgnorable(it) && it < 256);
    }

    public void doScript(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String var, @QueryParameter String methods) throws IOException {
        String script;
        String boundUrl = req.getRestOfPath();
        if (var == null) {
            return;
        }
        if (!BoundObjectTable.isValidJavaScriptIdentifier(var)) {
            LOGGER.log(Level.FINE, () -> "Rejecting invalid JavaScript identifier: " + var);
            return;
        }
        rsp.setContentType("text/javascript");
        PrintWriter writer = rsp.getWriter();
        if ("/null".equals(boundUrl)) {
            writer.append(var).append(" = null;");
            return;
        }
        String contextAndPrefix = Stapler.getCurrentRequest2().getContextPath() + PREFIX;
        if (boundUrl.startsWith(contextAndPrefix)) {
            String id = boundUrl.replace(contextAndPrefix, "");
            Table table = this.resolve(false);
            if (table == null) {
                rsp.sendError(404);
                return;
            }
            Object object = table.resolve(id);
            if (object == null) {
                writer.append(var).append(" = null;");
                return;
            }
            script = Bound.getProxyScript(boundUrl, object.getClass());
        } else {
            if (methods == null) {
                return;
            }
            String[] methodsArray = methods.split(",");
            if (Arrays.stream(methodsArray).anyMatch(it -> !BoundObjectTable.isValidJavaIdentifier(it))) {
                LOGGER.log(Level.FINE, () -> "Rejecting method list that includes an invalid Java identifier: " + methods);
                return;
            }
            script = Bound.getProxyScript(boundUrl, methodsArray);
        }
        writer.append(var).append(" = ").append(script).append(";");
    }

    @Override
    public Table getStaplerFallback() {
        return this.resolve(false);
    }

    public Bound bind(Object o) {
        return this.resolve(true).add(new StrongRef(o));
    }

    public void releaseMe() {
        Ancestor eot = Stapler.getCurrentRequest2().findAncestor(BoundObjectTable.class);
        if (eot == null) {
            throw new IllegalStateException("The thread is not handling a request to a abound object");
        }
        String id = eot.getNextToken(0);
        this.resolve(false).release(id);
    }

    private Table resolve(boolean createIfNotExist) {
        HttpSession session = Stapler.getCurrentRequest2().getSession(createIfNotExist);
        if (session == null) {
            return null;
        }
        Table t = (Table)session.getAttribute(Table.class.getName());
        if (t == null) {
            if (createIfNotExist) {
                t = new Table();
                session.setAttribute(Table.class.getName(), (Object)t);
            } else {
                return null;
            }
        }
        return t;
    }

    public Table getTable() {
        return this.resolve(true);
    }

    public static class Table
    implements Serializable {
        private final Map<String, Ref> entries = new HashMap<String, Ref>();

        private synchronized Bound add(Ref ref) {
            final Object target = ref.get();
            if (target instanceof WithWellKnownURL) {
                WithWellKnownURL w = (WithWellKnownURL)target;
                String url = w.getWellKnownUrl();
                if (!url.startsWith("/")) {
                    LOGGER.warning("WithWellKnownURL.getWellKnownUrl must start with a slash. But we got " + url + " from " + String.valueOf(w));
                }
                return new WellKnownObjectHandle(url, w);
            }
            Iterator<Map.Entry<String, Ref>> it = this.entries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Ref> entry = it.next();
                if (entry.getValue().valid()) continue;
                LOGGER.fine(() -> "removing stale " + (String)entry.getKey() + ": " + String.valueOf(((Ref)entry.getValue()).get()));
                it.remove();
            }
            final String id = UUID.randomUUID().toString();
            this.entries.put(id, ref);
            LOGGER.fine(() -> String.format("%s binding %s for %s", this.toString(), target, id));
            return new Bound(){

                @Override
                public void release() {
                    this.release(id);
                }

                @Override
                public String getURL() {
                    return Stapler.getCurrentRequest2().getContextPath() + BoundObjectTable.PREFIX + id;
                }

                @Override
                public Object getTarget() {
                    return target;
                }

                @Override
                public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
                    rsp.sendRedirect2(this.getURL());
                }
            };
        }

        public Object getDynamic(String id) {
            return this.resolve(id);
        }

        public void release(String id) {
            Ref ref = this.entries.remove(id);
            LOGGER.fine(() -> "releasing " + id + ": " + String.valueOf(ref != null ? ref.get() : null));
        }

        private synchronized Object resolve(String id) {
            Ref e = this.entries.get(id);
            if (e == null) {
                LOGGER.fine(() -> this.toString() + " doesn't have binding for " + id);
                return null;
            }
            return e.get();
        }
    }

    private static class StrongRef
    implements Ref {
        private final Object o;
        private final long expiration;

        StrongRef(Object o) {
            this.o = o;
            this.expiration = System.currentTimeMillis() + EXPIRATION_TIME;
        }

        @Override
        public Object get() {
            return this.o;
        }

        @Override
        public boolean valid() {
            return this.expiration == 0L || System.currentTimeMillis() < this.expiration;
        }

        private Object writeReplace() {
            if (this.o instanceof Serializable) {
                return this;
            }
            LOGGER.fine(() -> "Refusing to serialize " + String.valueOf(this.o));
            return new StrongRef(null);
        }
    }

    static interface Ref
    extends Serializable {
        public Object get();

        public boolean valid();
    }

    private static final class WellKnownObjectHandle
    extends Bound {
        private final String url;
        private final Object target;

        WellKnownObjectHandle(String url, Object target) {
            this.url = url;
            this.target = target;
        }

        @Override
        public void release() {
        }

        @Override
        public String getURL() {
            return Stapler.getCurrentRequest2().getContextPath() + this.url;
        }

        @Override
        public Object getTarget() {
            return this.target;
        }

        @Override
        public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
            rsp.sendRedirect2(this.getURL());
        }
    }
}

