/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.fmt;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.tags.fmt.LocalizationContext;

public class BundleTag
extends TagSupport {
    private static final Locale EMPTY_LOCALE = new Locale("", "");
    private Expression basename;
    private Expression prefix;
    private String ebasename;
    private String eprefix;
    private LocalizationContext locCtxt;

    public LocalizationContext getLocalizationContext() {
        return this.locCtxt;
    }

    public String getPrefixAsString() {
        return this.eprefix;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        Object basenameInput = null;
        if (this.basename != null) {
            basenameInput = this.basename.evaluate(this.context);
        }
        if (basenameInput != null) {
            this.ebasename = basenameInput.toString();
        }
        Object prefixInput = null;
        if (this.prefix != null) {
            prefixInput = this.prefix.evaluate(this.context);
        }
        if (prefixInput != null) {
            this.eprefix = prefixInput.toString();
        }
        this.locCtxt = BundleTag.getLocalizationContext(this.context, this.ebasename);
        this.invokeBody(output);
    }

    public static LocalizationContext getLocalizationContext(JellyContext jc) {
        LocalizationContext locCtxt = null;
        Object obj = jc.getVariable("org.apache.commons.jelly.tags.fmt.localizationContext");
        if (obj == null) {
            return null;
        }
        locCtxt = obj instanceof LocalizationContext ? (LocalizationContext)obj : BundleTag.getLocalizationContext(jc, (String)obj);
        return locCtxt;
    }

    public static LocalizationContext getLocalizationContext(JellyContext jc, String basename) {
        LocalizationContext locCtxt = null;
        ResourceBundle bundle = null;
        if (basename == null || basename.equals("")) {
            return new LocalizationContext();
        }
        Locale pref = null;
        Object tmp = jc.getVariable("org.apache.commons.jelly.tags.fmt.locale");
        if (tmp != null && tmp instanceof Locale) {
            pref = (Locale)tmp;
        }
        if (pref != null && (bundle = BundleTag.findMatch(basename, pref, jc.getClassLoader())) != null) {
            locCtxt = new LocalizationContext(bundle, pref);
        }
        if (locCtxt == null) {
            tmp = jc.getVariable("org.apache.commons.jelly.tags.fmt.fallbackLocale");
            if (tmp != null && tmp instanceof Locale) {
                pref = (Locale)tmp;
            }
            if (pref != null && (bundle = BundleTag.findMatch(basename, pref, jc.getClassLoader())) != null) {
                locCtxt = new LocalizationContext(bundle, pref);
            }
        }
        if (locCtxt == null) {
            try {
                bundle = ResourceBundle.getBundle(basename, EMPTY_LOCALE, jc.getClassLoader());
                if (bundle != null) {
                    locCtxt = new LocalizationContext(bundle, null);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (locCtxt != null) {
            if (locCtxt.getLocale() != null) {
                // empty if block
            }
        } else {
            locCtxt = new LocalizationContext();
        }
        return locCtxt;
    }

    private static ResourceBundle findMatch(String basename, Locale pref, ClassLoader cl) {
        ResourceBundle match = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(basename, pref, cl);
            Locale avail = bundle.getLocale();
            if (pref.equals(avail)) {
                match = bundle;
            } else if (pref.getLanguage().equals(avail.getLanguage()) && "".equals(avail.getCountry())) {
                match = bundle;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return match;
    }

    public void setBasename(Expression basename) {
        this.basename = basename;
    }

    public void setPrefix(Expression prefix) {
        this.prefix = prefix;
    }
}

