/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import jenkins.util.InterceptingScheduledExecutorService;
import org.acegisecurity.Authentication;

public final class ImpersonatingScheduledExecutorService
extends InterceptingScheduledExecutorService {
    private final org.springframework.security.core.Authentication authentication;

    public ImpersonatingScheduledExecutorService(ScheduledExecutorService base, org.springframework.security.core.Authentication authentication) {
        super(base);
        this.authentication = authentication;
    }

    @Deprecated
    public ImpersonatingScheduledExecutorService(ScheduledExecutorService base, Authentication authentication) {
        this(base, authentication.toSpring());
    }

    @Override
    protected Runnable wrap(final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                try (ACLContext ctxt = ACL.as2(ImpersonatingScheduledExecutorService.this.authentication);){
                    r.run();
                }
            }
        };
    }

    @Override
    protected <V> Callable<V> wrap(final Callable<V> r) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                try (ACLContext ctxt = ACL.as2(ImpersonatingScheduledExecutorService.this.authentication);){
                    Object v = r.call();
                    return v;
                }
            }
        };
    }
}

