/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import hudson.FilePath;
import hudson.Util;
import hudson.util.IOUtils;
import hudson.util.io.Archiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.tools.zip.Zip64Mode;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

final class ZipArchiver
extends Archiver {
    private final byte[] buf = new byte[8192];
    private final ZipOutputStream zip;
    private final OpenOption[] openOptions;
    private final String prefix;
    private static final long BITMASK_IS_DIRECTORY = 16L;

    ZipArchiver(OutputStream out) {
        this(out, "", Charset.defaultCharset(), new OpenOption[0]);
    }

    @Restricted(value={NoExternalUse.class})
    ZipArchiver(OutputStream out, String prefix, Charset filenamesEncoding, OpenOption ... openOptions) {
        this.openOptions = openOptions;
        this.prefix = prefix == null || prefix.isBlank() ? "" : Util.ensureEndsWith(prefix, "/");
        this.zip = new ZipOutputStream(out);
        this.zip.setEncoding(filenamesEncoding.name());
        this.zip.setUseZip64(Zip64Mode.AsNeeded);
    }

    @Override
    public void visit(File f, String _relativePath) throws IOException {
        int mode = IOUtils.mode(f);
        String relativePath = _relativePath.replace('\\', '/');
        BasicFileAttributes basicFileAttributes = Files.readAttributes(Util.fileToPath(f), BasicFileAttributes.class, new LinkOption[0]);
        if (basicFileAttributes.isDirectory()) {
            ZipEntry dirZipEntry = new ZipEntry(this.prefix + relativePath + "/");
            dirZipEntry.setExternalAttributes(16L);
            if (mode != -1) {
                dirZipEntry.setUnixMode(mode);
            }
            dirZipEntry.setTime(basicFileAttributes.lastModifiedTime().toMillis());
            this.zip.putNextEntry(dirZipEntry);
            this.zip.closeEntry();
        } else {
            ZipEntry fileZipEntry = new ZipEntry(this.prefix + relativePath);
            if (mode != -1) {
                fileZipEntry.setUnixMode(mode);
            }
            fileZipEntry.setTime(basicFileAttributes.lastModifiedTime().toMillis());
            fileZipEntry.setSize(basicFileAttributes.size());
            this.zip.putNextEntry(fileZipEntry);
            try (InputStream in = FilePath.openInputStream(f, this.openOptions);){
                int len;
                while ((len = in.read(this.buf)) >= 0) {
                    this.zip.write(this.buf, 0, len);
                }
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            this.zip.closeEntry();
        }
        ++this.entriesWritten;
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }
}

