/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;

@Deprecated
public class ReopenableFileOutputStream
extends OutputStream {
    protected final File out;
    private OutputStream current;
    private boolean appendOnNextOpen = false;

    public ReopenableFileOutputStream(File out) {
        this.out = out;
    }

    private synchronized OutputStream current() throws IOException {
        if (this.current == null) {
            try {
                this.current = Files.newOutputStream(this.out.toPath(), StandardOpenOption.CREATE, this.appendOnNextOpen ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (FileNotFoundException | InvalidPathException | NoSuchFileException e) {
                throw new IOException("Failed to open " + String.valueOf(this.out), e);
            }
        }
        return this.current;
    }

    @Override
    public void write(int b) throws IOException {
        this.current().write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.current().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.current().write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.current().flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.current != null) {
            this.current.close();
            this.appendOnNextOpen = true;
            this.current = null;
        }
    }

    public synchronized void rewind() throws IOException {
        this.close();
        this.appendOnNextOpen = false;
    }
}

