/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Functions;
import hudson.Main;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.console.ConsoleLogFilter;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.CommandTransport;
import hudson.remoting.Engine;
import hudson.remoting.Launcher;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.ComputerLauncherFilter;
import hudson.slaves.ComputerListener;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.Messages;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.util.Futures;
import hudson.util.RingBufferLogHandler;
import hudson.util.StreamTaskListener;
import hudson.util.io.RewindableFileOutputStream;
import hudson.util.io.RewindableRotatingFileOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.agents.AgentComputerUtil;
import jenkins.model.Jenkins;
import jenkins.security.ChannelConfigurator;
import jenkins.security.MasterToSlaveCallable;
import jenkins.slaves.EncryptedSlaveAgentJnlpFile;
import jenkins.slaves.JnlpAgentReceiver;
import jenkins.slaves.systemInfo.SlaveSystemInfo;
import jenkins.util.Listeners;
import jenkins.util.SystemProperties;
import org.jenkinsci.remoting.ChannelStateException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class SlaveComputer
extends Computer {
    private volatile Channel channel;
    private volatile transient boolean acceptingTasks = true;
    private Charset defaultCharset;
    private Boolean isUnix;
    private ComputerLauncher launcher;
    private final RewindableFileOutputStream log;
    private final TaskListener taskListener;
    private transient int numRetryAttempt;
    private volatile Future<?> lastConnectActivity = null;
    private Object constructed = new Object();
    private volatile transient String absoluteRemoteFs;
    private final Object channelLock = new Object();
    private static final Logger logger = Logger.getLogger(SlaveComputer.class.getName());
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean ALLOW_UNSUPPORTED_REMOTING_VERSIONS = SystemProperties.getBoolean(SlaveComputer.class.getName() + ".allowUnsupportedRemotingVersions");
    private static final int DEFAULT_RING_BUFFER_SIZE = SystemProperties.getInteger(RingBufferLogHandler.class.getName() + ".defaultSize", 256);
    private static final Logger LOGGER = Logger.getLogger(SlaveComputer.class.getName());

    public SlaveComputer(Slave slave) {
        super(slave);
        this.log = new RewindableRotatingFileOutputStream(this.getLogFile(), 10);
        this.taskListener = new StreamTaskListener(this.decorate(this.log));
        assert (slave.getNumExecutors() != 0) : "Computer created with 0 executors";
    }

    private OutputStream decorate(OutputStream os) {
        for (ConsoleLogFilter f : ConsoleLogFilter.all()) {
            try {
                os = f.decorateLogger(this, os);
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.WARNING, "Failed to filter log with " + String.valueOf(f), e);
            }
        }
        return os;
    }

    @Override
    @OverrideMustInvoke
    public boolean isAcceptingTasks() {
        return this.acceptingTasks && super.isAcceptingTasks();
    }

    public String getJnlpMac() {
        return JnlpAgentReceiver.SLAVE_SECRET.mac(this.getName());
    }

    public void setAcceptingTasks(boolean acceptingTasks) {
        this.acceptingTasks = acceptingTasks;
    }

    @Override
    public Boolean isUnix() {
        return this.isUnix;
    }

    @Override
    @CheckForNull
    public Slave getNode() {
        Node node = super.getNode();
        if (node == null || node instanceof Slave) {
            return (Slave)node;
        }
        logger.log(Level.WARNING, "found an unexpected kind of node {0} from {1} with nodeName={2}", new Object[]{node, this, this.nodeName});
        return null;
    }

    @NonNull
    public TaskListener getListener() {
        return this.taskListener;
    }

    @Override
    public String getIconClassName() {
        Future<?> l = this.lastConnectActivity;
        if (l != null && !l.isDone()) {
            return "symbol-computer";
        }
        return super.getIconClassName();
    }

    @Override
    @Deprecated
    public boolean isJnlpAgent() {
        return this.launcher instanceof JNLPLauncher;
    }

    @Override
    public boolean isLaunchSupported() {
        return this.launcher.isLaunchSupported();
    }

    public ComputerLauncher getLauncher() {
        return this.launcher;
    }

    public ComputerLauncher getDelegatedLauncher() {
        ComputerLauncher l = this.launcher;
        while (true) {
            if (l instanceof DelegatingComputerLauncher) {
                l = ((DelegatingComputerLauncher)l).getLauncher();
                continue;
            }
            if (!(l instanceof ComputerLauncherFilter)) break;
            l = ((ComputerLauncherFilter)l).getCore();
        }
        return l;
    }

    @Override
    protected Future<?> _connect(boolean forceReconnect) {
        if (this.channel != null) {
            return Futures.precomputed(null);
        }
        if (!forceReconnect && this.isConnecting()) {
            return this.lastConnectActivity;
        }
        if (forceReconnect && this.isConnecting()) {
            logger.fine("Forcing a reconnect on " + this.getName());
        }
        this.closeChannel();
        Throwable threadInfo = new Throwable("launched here");
        this.lastConnectActivity = Computer.threadPoolForRemoting.submit(() -> {
            try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
                this.log.rewind();
                try {
                    for (ComputerListener cl : ComputerListener.all()) {
                        cl.preLaunch(this, this.taskListener);
                    }
                    this.offlineCause = null;
                    this.launcher.launch(this, this.taskListener);
                }
                catch (AbortException e) {
                    e.addSuppressed(threadInfo);
                    this.taskListener.error(e.getMessage());
                    throw e;
                }
                catch (IOException e) {
                    e.addSuppressed(threadInfo);
                    Util.displayIOException(e, this.taskListener);
                    Functions.printStackTrace((Throwable)e, this.taskListener.error(Messages.ComputerLauncher_unexpectedError()));
                    throw e;
                }
                catch (InterruptedException e) {
                    e.addSuppressed(threadInfo);
                    Functions.printStackTrace((Throwable)e, this.taskListener.error(Messages.ComputerLauncher_abortedLaunch()));
                    throw e;
                }
                catch (Error | RuntimeException e) {
                    e.addSuppressed(threadInfo);
                    Functions.printStackTrace(e, this.taskListener.error(Messages.ComputerLauncher_unexpectedError()));
                    throw e;
                }
            }
            finally {
                if (this.channel == null && this.offlineCause == null) {
                    this.offlineCause = new OfflineCause.LaunchFailed();
                    for (ComputerListener cl : ComputerListener.all()) {
                        cl.onLaunchFailure(this, this.taskListener);
                    }
                }
            }
            if (this.channel == null) {
                throw new IOException("Agent failed to connect, even though the launcher didn't report it. See the log output for details.");
            }
            return null;
        });
        return this.lastConnectActivity;
    }

    @Override
    public void taskAccepted(Executor executor, Queue.Task task) {
        Slave node;
        LOGGER.log(Level.FINER, "Accepted {0} on {1}", new Object[]{task.toString(), executor.getOwner().getDisplayName()});
        if (this.launcher instanceof ExecutorListener) {
            ((ExecutorListener)((Object)this.launcher)).taskAccepted(executor, task);
        }
        if ((node = this.getNode()) != null && node.getRetentionStrategy() instanceof ExecutorListener) {
            ((ExecutorListener)((Object)node.getRetentionStrategy())).taskAccepted(executor, task);
        }
    }

    @Override
    public void taskStarted(Executor executor, Queue.Task task) {
        RetentionStrategy r;
        LOGGER.log(Level.FINER, "Started {0} on {1}", new Object[]{task.toString(), executor.getOwner().getDisplayName()});
        if (this.launcher instanceof ExecutorListener) {
            ((ExecutorListener)((Object)this.launcher)).taskStarted(executor, task);
        }
        if ((r = this.getRetentionStrategy()) instanceof ExecutorListener) {
            ((ExecutorListener)((Object)r)).taskStarted(executor, task);
        }
    }

    @Override
    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        RetentionStrategy r;
        LOGGER.log(Level.FINE, "Completed {0} on {1}", new Object[]{task.toString(), executor.getOwner().getDisplayName()});
        if (this.launcher instanceof ExecutorListener) {
            ((ExecutorListener)((Object)this.launcher)).taskCompleted(executor, task, durationMS);
        }
        if ((r = this.getRetentionStrategy()) instanceof ExecutorListener) {
            ((ExecutorListener)((Object)r)).taskCompleted(executor, task, durationMS);
        }
    }

    @Override
    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        RetentionStrategy r;
        LOGGER.log(Level.FINE, "Completed with problems {0} on {1}", new Object[]{task.toString(), executor.getOwner().getDisplayName()});
        if (this.launcher instanceof ExecutorListener) {
            ((ExecutorListener)((Object)this.launcher)).taskCompletedWithProblems(executor, task, durationMS, problems);
        }
        if ((r = this.getRetentionStrategy()) instanceof ExecutorListener) {
            ((ExecutorListener)((Object)r)).taskCompletedWithProblems(executor, task, durationMS, problems);
        }
    }

    @Override
    public boolean isConnecting() {
        Future<?> l = this.lastConnectActivity;
        return this.isOffline() && l != null && !l.isDone();
    }

    public OutputStream openLogFile() {
        try {
            this.log.rewind();
            return this.decorate(this.log);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to create log file " + String.valueOf(this.getLogFile()), e);
            return OutputStream.nullOutputStream();
        }
    }

    public void setChannel(@NonNull InputStream in, @NonNull OutputStream out, @NonNull TaskListener taskListener, @CheckForNull Channel.Listener listener) throws IOException, InterruptedException {
        this.setChannel(in, out, taskListener.getLogger(), listener);
    }

    public void setChannel(@NonNull InputStream in, @NonNull OutputStream out, @CheckForNull OutputStream launchLog, @CheckForNull Channel.Listener listener) throws IOException, InterruptedException {
        ChannelBuilder cb = new ChannelBuilder(this.nodeName, threadPoolForRemoting).withMode(Channel.Mode.NEGOTIATE).withHeaderStream(launchLog);
        for (ChannelConfigurator cc : ChannelConfigurator.all()) {
            cc.onChannelBuilding(cb, this);
        }
        Channel channel = cb.build(in, out);
        this.setChannel(channel, launchLog, listener);
    }

    @Restricted(value={Beta.class})
    public void setChannel(@NonNull ChannelBuilder cb, @NonNull CommandTransport commandTransport, @CheckForNull Channel.Listener listener) throws IOException, InterruptedException {
        for (ChannelConfigurator cc : ChannelConfigurator.all()) {
            cc.onChannelBuilding(cb, this);
        }
        OutputStream headerStream = cb.getHeaderStream();
        if (headerStream == null) {
            LOGGER.log(Level.WARNING, "No header stream defined when setting channel for computer {0}. Launch log won't be printed", this);
        }
        Channel channel = cb.build(commandTransport);
        this.setChannel(channel, headerStream, listener);
    }

    @CheckReturnValue
    public int getClassLoadingCount() throws IOException, InterruptedException {
        if (this.channel == null) {
            return -1;
        }
        return this.channel.call(new LoadingCount(false));
    }

    @CheckReturnValue
    public int getClassLoadingPrefetchCacheCount() throws IOException, InterruptedException {
        if (this.channel == null) {
            return -1;
        }
        if (!this.channel.remoteCapability.supportsPrefetch()) {
            return -1;
        }
        return this.channel.call(new LoadingPrefetchCacheCount());
    }

    @CheckReturnValue
    public int getResourceLoadingCount() throws IOException, InterruptedException {
        if (this.channel == null) {
            return -1;
        }
        return this.channel.call(new LoadingCount(true));
    }

    @CheckReturnValue
    public long getClassLoadingTime() throws IOException, InterruptedException {
        if (this.channel == null) {
            return -1L;
        }
        return this.channel.call(new LoadingTime(false));
    }

    @CheckReturnValue
    public long getResourceLoadingTime() throws IOException, InterruptedException {
        if (this.channel == null) {
            return -1L;
        }
        return this.channel.call(new LoadingTime(true));
    }

    @CheckForNull
    public String getAbsoluteRemoteFs() {
        return this.channel == null ? null : this.absoluteRemoteFs;
    }

    @Exported
    @Restricted(value={DoNotUse.class})
    @CheckForNull
    public String getAbsoluteRemotePath() {
        if (this.hasPermission(CONNECT)) {
            return this.getAbsoluteRemoteFs();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public void setChannel(@NonNull Channel channel, @CheckForNull OutputStream launchLog, @CheckForNull Channel.Listener listener) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    @Override
    public List<LogRecord> getLogRecords() throws IOException, InterruptedException {
        if (this.channel == null) {
            return Collections.emptyList();
        }
        return this.channel.call(new SlaveLogFetcher());
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public synchronized void doSubmitDescription(StaplerResponse2 rsp, @QueryParameter String description) throws IOException {
        this.checkPermission(CONFIGURE);
        Slave node = this.getNode();
        if (node == null) {
            throw new IOException("Description will be not set. The node " + this.nodeName + " does not exist (anymore).");
        }
        node.setNodeDescription(description);
        rsp.sendRedirect(".");
    }

    @RequirePOST
    public HttpResponse doDoDisconnect(@QueryParameter String offlineMessage) {
        if (this.channel != null) {
            this.checkPermission(DISCONNECT);
            offlineMessage = Util.fixEmptyAndTrim(offlineMessage);
            this.disconnect(new OfflineCause.UserCause(User.current(), offlineMessage));
        }
        return new HttpRedirect(".");
    }

    @Override
    public Future<?> disconnect(OfflineCause cause) {
        super.disconnect(cause);
        return Computer.threadPoolForRemoting.submit(new Runnable(){

            @Override
            public void run() {
                SlaveComputer.this.launcher.beforeDisconnect(SlaveComputer.this, SlaveComputer.this.taskListener);
                SlaveComputer.this.closeChannel();
                SlaveComputer.this.launcher.afterDisconnect(SlaveComputer.this, SlaveComputer.this.taskListener);
            }
        });
    }

    @Override
    @RequirePOST
    public void doLaunchSlaveAgent(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        this.checkPermission(CONNECT);
        if (this.channel != null) {
            try {
                req.getView((Object)this, "already-launched.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            }
            catch (IOException x) {
                throw x;
            }
            catch (Exception x) {
                throw new IOException(x);
            }
            return;
        }
        this.connect(true);
        rsp.sendRedirect("log");
    }

    public void tryReconnect() {
        ++this.numRetryAttempt;
        if (this.numRetryAttempt < 6 || this.numRetryAttempt % 12 == 0) {
            logger.info("Attempting to reconnect " + this.nodeName);
            this.connect(true);
        }
    }

    @Deprecated
    public Slave.JnlpJar getJnlpJars(String fileName) {
        return new Slave.JnlpJar(fileName);
    }

    @WebMethod(name={"slave-agent.jnlp"})
    public HttpResponse doSlaveAgentJnlp(StaplerRequest2 req, StaplerResponse2 res) {
        return this.doJenkinsAgentJnlp(req, res);
    }

    @WebMethod(name={"jenkins-agent.jnlp"})
    public HttpResponse doJenkinsAgentJnlp(StaplerRequest2 req, StaplerResponse2 res) {
        LOGGER.log(Level.WARNING, "Agent \"" + this.getName() + "\" is connecting with the \"-jnlpUrl\" argument, which is deprecated. Use \"-url\" and \"-name\" instead, potentially also passing in \"-webSocket\", \"-tunnel\", and/or work directory options as needed.");
        return new EncryptedSlaveAgentJnlpFile(this, "jenkins-agent.jnlp.jelly", this.getName(), CONNECT);
    }

    @Override
    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK && !Jenkins.get().hasPermission(Jenkins.READ)) {
            return new LowPermissionResponse();
        }
        return this;
    }

    @Override
    protected void kill() {
        super.kill();
        this.closeChannel();
        this.closeLog();
        try {
            Util.deleteRecursive(this.getLogDir());
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Unable to delete agent logs", ex);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public void closeLog() {
        try {
            this.log.close();
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "Failed to close agent log", x);
        }
    }

    @Override
    public RetentionStrategy getRetentionStrategy() {
        Slave n = this.getNode();
        return n == null ? RetentionStrategy.NOOP : n.getRetentionStrategy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChannel() {
        Channel c;
        Object object = this.channelLock;
        synchronized (object) {
            c = this.channel;
            this.channel = null;
            this.absoluteRemoteFs = null;
            this.isUnix = null;
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to terminate channel to " + this.getDisplayName(), e);
            }
            Listeners.notify(ComputerListener.class, true, l -> l.onOffline(this, this.offlineCause));
        }
    }

    @Override
    @SuppressFBWarnings(value={"UR_UNINIT_READ_CALLED_FROM_SUPER_CONSTRUCTOR"}, justification="TODO needs triage")
    protected void setNode(Node node) {
        super.setNode(node);
        this.launcher = this.grabLauncher(node);
        if (this.constructed != null) {
            if (node instanceof Slave) {
                Slave slave = (Slave)node;
                Queue.runWithLock(() -> slave.getRetentionStrategy().check(this));
            } else {
                this.connect(false);
            }
        }
    }

    public String toString() {
        return this.nodeName != null ? super.toString() + "[" + this.nodeName + "]" : super.toString();
    }

    protected ComputerLauncher grabLauncher(Node node) {
        return ((Slave)node).getLauncher();
    }

    @CheckReturnValue
    public String getSlaveVersion() throws IOException, InterruptedException {
        if (this.channel == null) {
            return "Unknown (agent is offline)";
        }
        return this.channel.call(new SlaveVersion());
    }

    @CheckReturnValue
    public String getOSDescription() throws IOException, InterruptedException {
        if (this.channel == null) {
            return "Unknown (agent is offline)";
        }
        return this.channel.call(new DetectOS()) != false ? "Unix" : "Windows";
    }

    @CheckReturnValue
    public Map<String, String> getEnvVarsFull() throws IOException, InterruptedException {
        if (this.channel == null) {
            TreeMap<String, String> env = new TreeMap<String, String>();
            env.put("N/A", "N/A");
            return env;
        }
        return this.channel.call(new ListFullEnvironment());
    }

    @Deprecated
    public static VirtualChannel getChannelToMaster() {
        return AgentComputerUtil.getChannelToController();
    }

    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.163")
    public static List<SlaveSystemInfo> getSystemInfoExtensions() {
        return SlaveSystemInfo.all();
    }

    static class LoadingCount
    extends MasterToSlaveCallable<Integer, RuntimeException> {
        private final boolean resource;

        LoadingCount(boolean resource) {
            this.resource = resource;
        }

        @Override
        public Integer call() {
            Channel c = Channel.current();
            if (c == null) {
                return -1;
            }
            return this.resource ? c.resourceLoadingCount.get() : c.classLoadingCount.get();
        }
    }

    static class LoadingPrefetchCacheCount
    extends MasterToSlaveCallable<Integer, RuntimeException> {
        LoadingPrefetchCacheCount() {
        }

        @Override
        public Integer call() {
            Channel c = Channel.current();
            if (c == null) {
                return -1;
            }
            return c.classLoadingPrefetchCacheCount.get();
        }
    }

    static class LoadingTime
    extends MasterToSlaveCallable<Long, RuntimeException> {
        private final boolean resource;

        LoadingTime(boolean resource) {
            this.resource = resource;
        }

        @Override
        public Long call() {
            Channel c = Channel.current();
            if (c == null) {
                return -1L;
            }
            return this.resource ? c.resourceLoadingTime.get() : c.classLoadingTime.get();
        }
    }

    private static final class SlaveVersion
    extends MasterToSlaveCallable<String, IOException> {
        private SlaveVersion() {
        }

        @Override
        public String call() throws IOException {
            try {
                return Launcher.VERSION;
            }
            catch (Throwable ex) {
                return "< 1.335";
            }
        }
    }

    private static final class CommunicationProtocol
    extends MasterToSlaveCallable<String, IOException> {
        private CommunicationProtocol() {
        }

        @Override
        public String call() throws IOException {
            try {
                Engine engine = Engine.current();
                if (engine != null) {
                    return engine.getProtocolName();
                }
                return Launcher.getCommunicationProtocolName();
            }
            catch (NoSuchMethodError ex) {
                return null;
            }
        }
    }

    private static final class DetectOS
    extends MasterToSlaveCallable<Boolean, IOException> {
        private DetectOS() {
        }

        @Override
        public Boolean call() throws IOException {
            return File.pathSeparatorChar == ':';
        }
    }

    private static final class DetectDefaultCharset
    extends MasterToSlaveCallable<String, IOException> {
        private DetectDefaultCharset() {
        }

        @Override
        public String call() throws IOException {
            return Charset.defaultCharset().name();
        }
    }

    private static final class AbsolutePath
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final String relativePath;

        private AbsolutePath(String relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public String call() throws IOException {
            return new File(this.relativePath).getAbsolutePath();
        }
    }

    private static class SlaveInitializer
    extends MasterToSlaveCallable<Void, RuntimeException> {
        final int ringBufferSize;
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = Logger.getLogger("");

        SlaveInitializer(int ringBufferSize) {
            this.ringBufferSize = ringBufferSize;
        }

        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="field is static for the reason explained in the Javadoc for LogHolder")
        private void setLogHandler() {
            LogHolder.SLAVE_LOG_HANDLER = new RingBufferLogHandler(this.ringBufferSize);
        }

        @Override
        public Void call() {
            this.setLogHandler();
            for (Handler h : LOGGER.getHandlers()) {
                if (!h.getClass().getName().equals(LogHolder.SLAVE_LOG_HANDLER.getClass().getName())) continue;
                LOGGER.removeHandler(h);
            }
            LOGGER.addHandler(LogHolder.SLAVE_LOG_HANDLER);
            try {
                Security.removeProvider("SunPKCS11-Solaris");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                this.getChannelOrFail().setProperty("agent", Boolean.TRUE);
            }
            catch (ChannelStateException e) {
                throw new IllegalStateException(e);
            }
            return null;
        }
    }

    private static class SlaveLogFetcher
    extends MasterToSlaveCallable<List<LogRecord>, RuntimeException> {
        private SlaveLogFetcher() {
        }

        @Override
        public List<LogRecord> call() {
            return new ArrayList<LogRecord>(LogHolder.SLAVE_LOG_HANDLER.getView());
        }
    }

    class LowPermissionResponse {
        LowPermissionResponse() {
        }

        @WebMethod(name={"jenkins-agent.jnlp"})
        public HttpResponse doJenkinsAgentJnlp(StaplerRequest2 req, StaplerResponse2 res) {
            return SlaveComputer.this.doJenkinsAgentJnlp(req, res);
        }

        @WebMethod(name={"slave-agent.jnlp"})
        public HttpResponse doSlaveAgentJnlp(StaplerRequest2 req, StaplerResponse2 res) {
            return SlaveComputer.this.doJenkinsAgentJnlp(req, res);
        }
    }

    private static class ListFullEnvironment
    extends MasterToSlaveCallable<Map<String, String>, IOException> {
        private ListFullEnvironment() {
        }

        @Override
        public Map<String, String> call() throws IOException {
            TreeMap<String, String> env = new TreeMap<String, String>(System.getenv());
            if (Main.isUnitTest || Main.isDevelopmentMode) {
                env.remove("MAVEN_OPTS");
            }
            return env;
        }
    }

    static final class LogHolder {
        static RingBufferLogHandler SLAVE_LOG_HANDLER;

        LogHolder() {
        }
    }
}

