/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import hudson.Functions;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.node_monitors.AbstractAsyncNodeMonitorDescriptor;
import hudson.node_monitors.AbstractDiskSpaceMonitor;
import hudson.node_monitors.Messages;
import hudson.node_monitors.MonitorOfflineCause;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

public abstract class DiskSpaceMonitorDescriptor
extends AbstractAsyncNodeMonitorDescriptor<DiskSpace> {
    private static final Logger LOGGER = Logger.getLogger(DiskSpaceMonitorDescriptor.class.getName());

    @Override
    protected Map<Computer, DiskSpace> monitor() throws InterruptedException {
        AbstractAsyncNodeMonitorDescriptor.Result base = this.monitorDetailed();
        Map<Computer, DiskSpace> data = base.getMonitoringData();
        AbstractDiskSpaceMonitor monitor = (AbstractDiskSpaceMonitor)ComputerSet.getMonitors().get(this);
        for (Map.Entry e : data.entrySet()) {
            Computer c = e.getKey();
            DiskSpace d = (DiskSpace)e.getValue();
            if (base.getSkipped().contains(c)) {
                assert (d == null);
                continue;
            }
            if (d == null) {
                d = (DiskSpace)this.get(c);
                e.setValue(d);
            }
            this.markNodeOfflineOrOnline(c, d, monitor);
        }
        return data;
    }

    @Restricted(value={NoExternalUse.class})
    public void markNodeOfflineOrOnline(Computer c, DiskSpace size, AbstractDiskSpaceMonitor monitor) {
        if (size != null) {
            long threshold = monitor.getThresholdBytes(c);
            size.setThreshold(threshold);
            long warningThreshold = monitor.getWarningThresholdBytes(c);
            size.setWarningThreshold(warningThreshold);
            if (size.size <= threshold) {
                size.setTrigger(monitor.getClass());
                if (this.markOffline(c, size)) {
                    LOGGER.warning(Messages.DiskSpaceMonitor_MarkedOffline(c.getDisplayName()));
                }
            }
            if (size.size > threshold && c.isOffline() && c.getOfflineCause() instanceof DiskSpace && monitor.getClass().equals(((DiskSpace)c.getOfflineCause()).getTrigger()) && this.markOnline(c)) {
                LOGGER.info(Messages.DiskSpaceMonitor_MarkedOnline(c.getDisplayName()));
            }
        }
    }

    @ExportedBean
    public static final class DiskSpace
    extends MonitorOfflineCause
    implements Serializable {
        private final String path;
        @Exported
        public final long size;
        private long totalSize;
        private Class<? extends AbstractDiskSpaceMonitor> trigger;
        private long threshold;
        private long warningThreshold;
        private static final long serialVersionUID = 2L;

        public DiskSpace(String path, long size) {
            this.path = path;
            this.size = size;
        }

        @Restricted(value={NoExternalUse.class})
        public void setTotalSize(long totalSize) {
            this.totalSize = totalSize;
        }

        @Restricted(value={NoExternalUse.class})
        @Exported
        public long getTotalSize() {
            return this.totalSize;
        }

        public String toString() {
            if (this.isTriggered()) {
                if (this.threshold >= 0L) {
                    return Messages.DiskSpaceMonitorDescriptor_DiskSpace_FreeSpaceTooLow(Functions.humanReadableByteSize(this.size), this.path, Functions.humanReadableByteSize(this.threshold), Functions.humanReadableByteSize(this.totalSize));
                }
                return Messages.DiskSpaceMonitorDescriptor_DiskSpace_FreeSpaceTooLow(Functions.humanReadableByteSize(this.size), this.path, "unset", Functions.humanReadableByteSize(this.totalSize));
            }
            if (this.isWarning()) {
                return Messages.DiskSpaceMonitorDescriptor_DiskSpace_FreeSpaceTooLow(Functions.humanReadableByteSize(this.size), this.path, Functions.humanReadableByteSize(this.warningThreshold), Functions.humanReadableByteSize(this.totalSize));
            }
            return Messages.DiskSpaceMonitorDescriptor_DiskSpace_FreeSpace(Functions.humanReadableByteSize(this.size), this.path, Functions.humanReadableByteSize(this.totalSize));
        }

        @Exported
        public String getPath() {
            return this.path;
        }

        @Restricted(value={DoNotUse.class})
        public long getFreeSize() {
            return this.size;
        }

        @Deprecated(since="2.434")
        public String getGbLeft() {
            long space = this.size;
            space /= 1024L;
            return new BigDecimal(space /= 1024L).scaleByPowerOfTen(-3).toPlainString();
        }

        public String toHtml() {
            return Functions.humanReadableByteSize(this.size);
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isTriggered() {
            return this.size <= this.threshold;
        }

        @Restricted(value={NoExternalUse.class})
        public boolean isWarning() {
            return this.size > this.threshold && this.size < this.warningThreshold;
        }

        protected void setTrigger(Class<? extends AbstractDiskSpaceMonitor> trigger) {
            this.trigger = trigger;
        }

        public void setThreshold(long threshold) {
            this.threshold = threshold;
        }

        @Exported
        public long getThreshold() {
            return this.threshold;
        }

        public void setWarningThreshold(long warningThreshold) {
            this.warningThreshold = warningThreshold;
        }

        @Exported
        public long getWarningThreshold() {
            return this.warningThreshold;
        }

        public Class<? extends AbstractDiskSpaceMonitor> getTrigger() {
            return this.trigger;
        }

        public static DiskSpace parse(String size) throws ParseException {
            if ((size = size.toUpperCase(Locale.ENGLISH).trim()).endsWith("B")) {
                size = size.substring(0, size.length() - 1);
            }
            if (size.endsWith("I")) {
                size = size.substring(0, size.length() - 1);
            }
            long multiplier = 1L;
            String suffix = "KMGT";
            for (int i = 0; i < suffix.length(); ++i) {
                if (!size.endsWith(suffix.substring(i, i + 1))) continue;
                multiplier = 1L;
                for (int j = 0; j <= i; ++j) {
                    multiplier *= 1024L;
                }
                size = size.substring(0, size.length() - 1);
            }
            try {
                return new DiskSpace("", (long)(Double.parseDouble(size.trim()) * (double)multiplier));
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(nfe.getLocalizedMessage(), 0);
            }
        }
    }

    protected static final class GetUsableSpace
    extends MasterToSlaveFileCallable<DiskSpace> {
        private static final long serialVersionUID = 1L;

        @Override
        public DiskSpace invoke(File f, VirtualChannel channel) throws IOException {
            long s = f.getUsableSpace();
            if (s <= 0L) {
                return null;
            }
            DiskSpace ds = new DiskSpace(f.getCanonicalPath(), s);
            ds.setTotalSize(f.getTotalSpace());
            return ds;
        }
    }
}

