/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractModelObject;
import hudson.model.Action;
import hudson.model.TaskThread;
import hudson.security.ACL;
import hudson.security.Permission;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.framework.io.LargeText;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class TaskAction
extends AbstractModelObject
implements Action {
    protected volatile transient TaskThread workerThread;
    protected transient WeakReference<AnnotatedLargeText> log;

    protected abstract Permission getPermission();

    protected abstract ACL getACL();

    @Override
    public abstract String getIconFileName();

    @Deprecated
    public LargeText getLog() {
        return this.obtainLog();
    }

    public AnnotatedLargeText obtainLog() {
        WeakReference<AnnotatedLargeText> l = this.log;
        if (l == null) {
            return null;
        }
        return (AnnotatedLargeText)((Object)l.get());
    }

    @Override
    public String getSearchUrl() {
        return this.getUrlName();
    }

    public TaskThread getWorkerThread() {
        return this.workerThread;
    }

    public void doProgressiveLog(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        AnnotatedLargeText text = this.obtainLog();
        if (text != null) {
            text.doProgressText(req, rsp);
            return;
        }
        rsp.setStatus(200);
    }

    public void doProgressiveHtml(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        AnnotatedLargeText text = this.obtainLog();
        if (text != null) {
            text.doProgressiveHtml(req, rsp);
            return;
        }
        rsp.setStatus(200);
    }

    @RequirePOST
    public synchronized void doClearError(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        if (this.workerThread != null && !this.workerThread.isRunning()) {
            this.workerThread = null;
        }
        rsp.sendRedirect(".");
    }
}

