/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.ezmorph.ObjectMorpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;

public final class BeanMorpher
implements ObjectMorpher {
    private static final Logger logger = Logger.getLogger(BeanMorpher.class.getName());
    private final Class beanClass;
    private boolean lenient;
    private final MorpherRegistry morpherRegistry;

    public BeanMorpher(Class beanClass, MorpherRegistry morpherRegistry) {
        this(beanClass, morpherRegistry, false);
    }

    public BeanMorpher(Class beanClass, MorpherRegistry morpherRegistry, boolean lenient) {
        this.validateClass(beanClass);
        if (morpherRegistry == null) {
            throw new MorphException("morpherRegistry is null");
        }
        this.beanClass = beanClass;
        this.morpherRegistry = morpherRegistry;
        this.lenient = lenient;
    }

    @Override
    public Object morph(Object sourceBean) {
        if (sourceBean == null) {
            return null;
        }
        if (!this.supports(sourceBean.getClass())) {
            throw new MorphException("unsupported class: " + sourceBean.getClass().getName());
        }
        Object targetBean = null;
        try {
            PropertyDescriptor[] targetPds;
            targetBean = this.beanClass.newInstance();
            for (PropertyDescriptor targetPd : targetPds = PropertyUtils.getPropertyDescriptors((Class)this.beanClass)) {
                String name = targetPd.getName();
                if (targetPd.getWriteMethod() == null) {
                    logger.log(Level.INFO, "Property '" + this.beanClass.getName() + "." + name + "' has no write method. SKIPPED.");
                    continue;
                }
                Class sourceType = null;
                if (sourceBean instanceof DynaBean) {
                    DynaBean dynaBean = (DynaBean)sourceBean;
                    DynaProperty dynaProperty = dynaBean.getDynaClass().getDynaProperty(name);
                    if (dynaProperty == null) {
                        logger.log(Level.WARNING, "DynaProperty '" + name + "' does not exist. SKIPPED.");
                        continue;
                    }
                    sourceType = dynaProperty.getType();
                } else {
                    PropertyDescriptor sourcePd = PropertyUtils.getPropertyDescriptor((Object)sourceBean, (String)name);
                    if (sourcePd == null) {
                        logger.log(Level.WARNING, "Property '" + sourceBean.getClass().getName() + "." + name + "' does not exist. SKIPPED.");
                        continue;
                    }
                    if (sourcePd.getReadMethod() == null) {
                        logger.log(Level.WARNING, "Property '" + sourceBean.getClass().getName() + "." + name + "' has no read method. SKIPPED.");
                        continue;
                    }
                    sourceType = sourcePd.getPropertyType();
                }
                Class<?> targetType = targetPd.getPropertyType();
                Object value = PropertyUtils.getProperty((Object)sourceBean, (String)name);
                this.setProperty(targetBean, name, sourceType, targetType, value);
            }
        }
        catch (MorphException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MorphException(e);
        }
        return targetBean;
    }

    @Override
    public Class morphsTo() {
        return this.beanClass;
    }

    @Override
    public boolean supports(Class clazz) {
        return !clazz.isArray();
    }

    private void setProperty(Object targetBean, String name, Class sourceType, Class targetType, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (targetType.isAssignableFrom(sourceType)) {
            if (value == null && targetType.isPrimitive()) {
                value = this.morpherRegistry.morph(targetType, value);
            }
            PropertyUtils.setProperty((Object)targetBean, (String)name, (Object)value);
        } else if (targetType.equals(Object.class)) {
            PropertyUtils.setProperty((Object)targetBean, (String)name, (Object)value);
        } else if (value == null) {
            if (targetType.isPrimitive()) {
                PropertyUtils.setProperty((Object)targetBean, (String)name, (Object)this.morpherRegistry.morph(targetType, value));
            }
        } else if (IdentityObjectMorpher.getInstance() == this.morpherRegistry.getMorpherFor(targetType)) {
            if (!this.lenient) {
                throw new MorphException("Can't find a morpher for target class " + targetType.getName() + " (" + name + ")");
            }
            logger.log(Level.INFO, "Can't find a morpher for target class " + targetType.getName() + " (" + name + ") SKIPPED");
        } else {
            PropertyUtils.setProperty((Object)targetBean, (String)name, (Object)this.morpherRegistry.morph(targetType, value));
        }
    }

    private void validateClass(Class clazz) {
        if (clazz == null) {
            throw new MorphException("target class is null");
        }
        if (clazz.isPrimitive()) {
            throw new MorphException("target class is a primitive");
        }
        if (clazz.isArray()) {
            throw new MorphException("target class is an array");
        }
        if (clazz.isInterface()) {
            throw new MorphException("target class is an interface");
        }
        if (DynaBean.class.isAssignableFrom(clazz)) {
            throw new MorphException("target class is a DynaBean");
        }
        if (Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz)) {
            throw new MorphException("target class is a wrapper");
        }
        if (String.class.isAssignableFrom(clazz)) {
            throw new MorphException("target class is a String");
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            throw new MorphException("target class is a Collection");
        }
        if (Map.class.isAssignableFrom(clazz)) {
            throw new MorphException("target class is a Map");
        }
    }
}

