/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.io;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.kohsuke.stapler.ReflectionUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.framework.io.ByteBuffer;
import org.kohsuke.stapler.framework.io.CharSpool;
import org.kohsuke.stapler.framework.io.LineEndNormalizingWriter;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

public class LargeText {
    private final Source source;
    protected final Charset charset;
    private volatile boolean completed;
    private static final int MAX_LINES_READ = 10000;

    public LargeText(File file, boolean completed) {
        this(file, Charset.defaultCharset(), completed);
    }

    public LargeText(File file, boolean completed, boolean transparentGunzip) {
        this(file, Charset.defaultCharset(), completed, transparentGunzip);
    }

    public LargeText(File file, Charset charset, boolean completed) {
        this(file, charset, completed, false);
    }

    public LargeText(final File file, Charset charset, boolean completed, boolean transparentGunzip) {
        this.charset = charset;
        this.source = transparentGunzip && GzipAwareSession.isGzipStream(file) ? new Source(){

            @Override
            public Session open() throws IOException {
                return new GzipAwareSession(file);
            }

            @Override
            public long length() {
                return GzipAwareSession.getGzipStreamSize(file);
            }

            @Override
            public boolean exists() {
                return file.exists();
            }
        } : new Source(){

            @Override
            public Session open() throws IOException {
                return new FileSession(file);
            }

            @Override
            public long length() {
                return file.length();
            }

            @Override
            public boolean exists() {
                return file.exists();
            }
        };
        this.completed = completed;
    }

    public LargeText(ByteBuffer memory, boolean completed) {
        this(memory, Charset.defaultCharset(), completed);
    }

    public LargeText(final ByteBuffer memory, Charset charset, boolean completed) {
        this.charset = charset;
        this.source = new Source(){

            @Override
            public Session open() throws IOException {
                return new BufferSession(memory);
            }

            @Override
            public long length() {
                return memory.length();
            }

            @Override
            public boolean exists() {
                return true;
            }
        };
        this.completed = completed;
    }

    public LargeText(Source source, Charset charset, boolean completed) {
        this.charset = charset;
        this.source = source;
        this.completed = completed;
    }

    public void markAsComplete() {
        this.completed = true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public long length() {
        return this.source.length();
    }

    public Reader readAll() throws IOException {
        return new InputStreamReader(new InputStream(){
            final Session session;
            {
                this.session = LargeText.this.source.open();
            }

            @Override
            public int read() throws IOException {
                byte[] buf = new byte[1];
                int n = this.session.read(buf);
                if (n == 1) {
                    return buf[0];
                }
                return -1;
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                return this.session.read(buf, off, len);
            }

            @Override
            public void close() throws IOException {
                this.session.close();
            }
        }, this.charset);
    }

    public long writeLogTo(long start, Writer w) throws IOException {
        return this.writeLogTo(start, new WriterOutputStream(w, this.charset));
    }

    public long writeLogTo(long start, OutputStream out) throws IOException {
        CountingOutputStream os = new CountingOutputStream(out);
        this.writeLogUncounted(start, (OutputStream)os);
        os.flush();
        return os.getByteCount() + start;
    }

    private void writeLogUncounted(long start, OutputStream os) throws IOException {
        try (Session f = this.source.open();){
            if (f.skip(start) != start) {
                throw new EOFException("Attempted to read past the end of the log");
            }
            if (this.completed) {
                int sz;
                byte[] buf = new byte[1024];
                while ((sz = f.read(buf)) >= 0) {
                    os.write(buf, 0, sz);
                }
            } else {
                ByteBuf buf = new ByteBuf(null, f);
                HeadMark head = new HeadMark(buf);
                TailMark tail = new TailMark(buf);
                buf = null;
                int readLines = 0;
                while (tail.moveToNextLine(f) && readLines++ < 10000) {
                    head.moveTo(tail, os);
                }
                head.finish(os);
            }
        }
    }

    public void doProgressText(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (ReflectionUtils.isOverridden(LargeText.class, this.getClass(), "doProgressText", StaplerRequest.class, StaplerResponse.class)) {
            this.doProgressText(StaplerRequest.fromStaplerRequest2(req), StaplerResponse.fromStaplerResponse2(rsp));
        } else {
            this.doProgressTextImpl(req, rsp);
        }
    }

    @Deprecated
    public void doProgressText(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.doProgressTextImpl(StaplerRequest.toStaplerRequest2(req), StaplerResponse.toStaplerResponse2(rsp));
    }

    private void doProgressTextImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        block28: {
            long textSize;
            CharSpool spool;
            long length;
            this.setContentType(rsp);
            rsp.setStatus(200);
            if (!this.source.exists()) {
                rsp.addHeader("X-Text-Size", "0");
                rsp.addHeader("X-More-Data", "true");
                return;
            }
            long start = 0L;
            String s = req.getParameter("start");
            if (s != null) {
                start = Long.parseLong(s);
            }
            if (start > (length = this.source.length())) {
                start = 0L;
            }
            if (this.delegateToWriteLogTo(req, rsp)) {
                spool = new CharSpool();
                textSize = this.writeLogTo(start, spool);
            } else {
                spool = null;
                textSize = length;
            }
            rsp.addHeader("X-Text-Size", String.valueOf(textSize));
            if (!this.completed) {
                rsp.addHeader("X-More-Data", "true");
            }
            try (PrintWriter w = rsp.getWriter();
                 LineEndNormalizingWriter lenw = new LineEndNormalizingWriter(w);){
                if (spool != null) {
                    spool.writeTo(lenw);
                    break block28;
                }
                try (WriterOutputStream os = new WriterOutputStream(lenw, this.charset);
                     ThresholdingOutputStream tos = new ThresholdingOutputStream(os, length - start);){
                    this.writeLogUncounted(start, tos);
                }
            }
        }
    }

    protected boolean delegateToWriteLogTo(StaplerRequest2 req, StaplerResponse2 rsp) {
        return false;
    }

    protected void setContentType(StaplerResponse2 rsp) {
        if (ReflectionUtils.isOverridden(LargeText.class, this.getClass(), "setContentType", StaplerResponse.class)) {
            this.setContentType(StaplerResponse.fromStaplerResponse2(rsp));
        } else {
            this.setContentTypeImpl(rsp);
        }
    }

    @Deprecated
    protected void setContentType(StaplerResponse rsp) {
        this.setContentTypeImpl(StaplerResponse.toStaplerResponse2(rsp));
    }

    private void setContentTypeImpl(StaplerResponse2 rsp) {
        rsp.setContentType("text/plain;charset=UTF-8");
    }

    private static final class GzipAwareSession
    implements Session {
        private final GZIPInputStream gz;

        GzipAwareSession(File file) throws IOException {
            this.gz = new GZIPInputStream(Files.newInputStream(file.toPath(), StandardOpenOption.READ));
        }

        @Override
        public void close() throws IOException {
            this.gz.close();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.gz.skip(n);
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.gz.read(buf);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            return this.gz.read(buf, offset, length);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static boolean isGzipStream(File file) {
            try (InputStream in = Files.newInputStream(file.toPath(), StandardOpenOption.READ);){
                boolean bl;
                try (DataInputStream din = new DataInputStream(in);){
                    bl = din.readShort() == 8075;
                }
                return bl;
            }
            catch (IOException ex) {
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static long getGzipStreamSize(File file) {
            if (!GzipAwareSession.isGzipStream(file)) {
                return file.length();
            }
            try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                if (raf.length() <= 4L) {
                    raf.close();
                    long l = file.length();
                    return l;
                }
                raf.seek(raf.length() - 4L);
                int b4 = raf.read();
                int b3 = raf.read();
                int b2 = raf.read();
                int b1 = raf.read();
                long l = (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
                return l;
            }
            catch (IOException ex) {
                return file.length();
            }
        }
    }

    public static interface Source {
        public Session open() throws IOException;

        public long length();

        public boolean exists();
    }

    public static interface Session
    extends Closeable {
        public long skip(long var1) throws IOException;

        public int read(byte[] var1) throws IOException;

        public int read(byte[] var1, int var2, int var3) throws IOException;
    }

    private static final class ByteBuf {
        private final byte[] buf = new byte[1024];
        private int size = 0;
        private ByteBuf next;

        ByteBuf(ByteBuf previous, Session f) throws IOException {
            if (previous != null) {
                assert (previous.next == null);
                previous.next = this;
            }
            while (!this.isFull()) {
                int chunk = f.read(this.buf, this.size, this.buf.length - this.size);
                if (chunk == -1) {
                    return;
                }
                this.size += chunk;
            }
        }

        public boolean isFull() {
            return this.buf.length == this.size;
        }
    }

    private static final class HeadMark
    extends Mark {
        HeadMark(ByteBuf buf) {
            super(buf);
        }

        void moveTo(Mark that, OutputStream os) throws IOException {
            while (this.buf != that.buf) {
                os.write(this.buf.buf, 0, this.buf.size);
                this.buf = this.buf.next;
                this.pos = 0;
            }
            this.pos = that.pos;
        }

        void finish(OutputStream os) throws IOException {
            os.write(this.buf.buf, 0, this.pos);
        }
    }

    private static final class TailMark
    extends Mark {
        TailMark(ByteBuf buf) {
            super(buf);
        }

        boolean moveToNextLine(Session f) throws IOException {
            while (true) {
                byte b;
                if (this.pos == this.buf.size) {
                    if (!this.buf.isFull()) {
                        return false;
                    }
                    this.buf = new ByteBuf(this.buf, f);
                    this.pos = 0;
                    continue;
                }
                if ((b = this.buf.buf[this.pos++]) == 13 || b == 10) break;
            }
            return true;
        }
    }

    private static class Mark {
        protected ByteBuf buf;
        protected int pos;

        Mark(ByteBuf buf) {
            this.buf = buf;
        }
    }

    private static final class ThresholdingOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private long remaining;

        ThresholdingOutputStream(OutputStream delegate, long threshold) {
            this.delegate = delegate;
            this.remaining = threshold;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.remaining > 0L) {
                this.delegate.write(b);
                --this.remaining;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.remaining >= (long)len) {
                this.delegate.write(b, off, len);
                this.remaining -= (long)len;
            } else if (this.remaining > 0L) {
                this.delegate.write(b, off, (int)this.remaining);
                this.remaining = 0L;
            }
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }
    }

    private static final class BufferSession
    implements Session {
        private final InputStream in;

        BufferSession(ByteBuffer buf) {
            this.in = buf.newInputStream();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.in.read(buf);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            return this.in.read(buf, offset, length);
        }
    }

    private static final class FileSession
    implements Session {
        private final RandomAccessFile file;

        FileSession(File file) throws IOException {
            this.file = new RandomAccessFile(file, "r");
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }

        @Override
        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            long pos = this.file.getFilePointer();
            long newPos = Math.min(this.file.length(), pos + n);
            this.file.seek(newPos);
            return newPos - pos;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.file.read(buf);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            return this.file.read(buf, offset, length);
        }
    }
}

