/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import org.kohsuke.stapler.Stapler;

public interface UncaughtExceptionHandler {
    public static final UncaughtExceptionHandler DEFAULT = new UncaughtExceptionHandler(){

        @Override
        @SuppressFBWarnings(value={"INFORMATION_EXPOSURE_THROUGH_AN_ERROR_MESSAGE", "XSS_SERVLET"}, justification="Info exposure is Covered by the escape() method. XSS is TODO needs triage")
        public void reportException(Throwable e, ServletContext context, HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            rsp.setStatus(500);
            rsp.setContentType("text/html");
            PrintWriter w = rsp.getWriter();
            String message = e.getMessage();
            w.print(MessageFormat.format("<html><head><title>Error {0}</title></head>\n<body bgcolor=#fff><h1>Status Code: {0}</h1>Exception: {1}<br>Stacktrace: <pre>{2}</pre><br><hr>\n<i>Generated by Stapler at {3}</i></body></html>", 500, message != null ? Stapler.escape(message) : "?", Stapler.escape(sw.toString()), new Date().toString()));
            w.close();
        }
    };

    public void reportException(Throwable var1, ServletContext var2, HttpServletRequest var3, HttpServletResponse var4) throws ServletException, IOException;
}

