/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import jenkins.util.InterceptingExecutorService;
import org.acegisecurity.Authentication;

public final class ImpersonatingExecutorService
extends InterceptingExecutorService {
    private final org.springframework.security.core.Authentication authentication;

    public ImpersonatingExecutorService(ExecutorService base, org.springframework.security.core.Authentication authentication) {
        super(base);
        this.authentication = authentication;
    }

    @Deprecated
    public ImpersonatingExecutorService(ExecutorService base, Authentication authentication) {
        this(base, authentication.toSpring());
    }

    @Override
    protected Runnable wrap(final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                try (ACLContext ctxt = ACL.as2(ImpersonatingExecutorService.this.authentication);){
                    r.run();
                }
            }
        };
    }

    @Override
    protected <V> Callable<V> wrap(final Callable<V> r) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                try (ACLContext ctxt = ACL.as2(ImpersonatingExecutorService.this.authentication);){
                    Object v = r.call();
                    return v;
                }
            }
        };
    }
}

