/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.FastPipedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;

public class FastPipedInputStream
extends InputStream {
    final byte[] buffer;
    ClosedBy closed = null;
    int readLaps = 0;
    int readPosition = 0;
    WeakReference<FastPipedOutputStream> source;
    int writeLaps = 0;
    int writePosition = 0;
    private final Throwable allocatedAt = new Throwable();

    public FastPipedInputStream() {
        this.buffer = new byte[65536];
    }

    public FastPipedInputStream(FastPipedOutputStream source) throws IOException {
        this(source, 65536);
    }

    public FastPipedInputStream(FastPipedOutputStream source, int bufferSize) throws IOException {
        if (source != null) {
            this.connect(source);
        }
        this.buffer = new byte[bufferSize];
    }

    private void checkSource() throws IOException {
        FastPipedOutputStream s = (FastPipedOutputStream)this.source.get();
        if (s == null) {
            throw new IOException("Writer side has already been abandoned", this.allocatedAt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.writePosition > this.readPosition ? this.writePosition - this.readPosition : (this.writePosition < this.readPosition ? this.buffer.length - this.readPosition + 1 + this.writePosition : (this.writeLaps > this.readLaps ? this.buffer.length : 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.source == null) {
            throw new IOException("Unconnected pipe");
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            this.closed = new ClosedBy(null);
            this.buffer.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void connect(FastPipedOutputStream source) throws IOException {
        if (this.source != null) {
            throw new IOException("Pipe already connected");
        }
        this.source = new WeakReference<FastPipedOutputStream>(source);
        source.sink = new WeakReference<FastPipedInputStream>(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b, 0, b.length) == -1 ? -1 : 0xFF & b[0];
    }

    @Override
    public int read(@NonNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int read(@NonNull byte[] b, int off, int len) throws IOException {
        if (this.source == null) {
            throw new IOException("Unconnected pipe");
        }
        while (true) {
            byte[] byArray = this.buffer;
            // MONITORENTER : this.buffer
            if (this.writePosition != this.readPosition || this.writeLaps != this.readLaps) break;
            if (this.closed != null) {
                Throwable c = this.closed.getCause();
                if (c != null) throw new IOException(c);
                // MONITOREXIT : byArray
                return -1;
            }
            this.checkSource();
            try {
                this.buffer.wait(FastPipedOutputStream.TIMEOUT);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        int amount = Math.min(len, (this.writePosition > this.readPosition ? this.writePosition : this.buffer.length) - this.readPosition);
        System.arraycopy(this.buffer, this.readPosition, b, off, amount);
        this.readPosition += amount;
        if (this.readPosition == this.buffer.length) {
            this.readPosition = 0;
            ++this.readLaps;
        }
        this.buffer.notifyAll();
        // MONITOREXIT : byArray
        return amount;
    }

    static final class ClosedBy
    extends Throwable {
        ClosedBy(Throwable error) {
            super("The pipe was closed at...", error);
        }
    }
}

