/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import com.google.common.escape.ArrayBasedCharEscaper;
import com.google.common.escape.CharEscaper;
import java.util.Map;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class SourceCodeEscapers {
    private static final Map<Character, String> REPLACEMENTS = Map.of(Character.valueOf('\b'), "\\b", Character.valueOf('\f'), "\\f", Character.valueOf('\n'), "\\n", Character.valueOf('\r'), "\\r", Character.valueOf('\t'), "\\t", Character.valueOf('\"'), "\\\"", Character.valueOf('\\'), "\\\\");
    private static final char PRINTABLE_ASCII_MIN = ' ';
    private static final char PRINTABLE_ASCII_MAX = '~';
    private static final CharEscaper JAVA_CHAR_ESCAPER = new JavaCharEscaper();

    private SourceCodeEscapers() {
        throw new AssertionError();
    }

    public static CharEscaper javaCharEscaper() {
        return JAVA_CHAR_ESCAPER;
    }

    private static class JavaCharEscaper
    extends ArrayBasedCharEscaper {
        JavaCharEscaper() {
            super(REPLACEMENTS, ' ', '~');
        }

        protected char[] escapeUnsafe(char c) {
            return String.format("\\u%04X", c).toCharArray();
        }
    }
}

