/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import java.util.ArrayList;
import java.util.List;

public abstract class SCMDecisionHandler
implements ExtensionPoint {
    public abstract boolean shouldPoll(@NonNull Item var1);

    @NonNull
    public static ExtensionList<SCMDecisionHandler> all() {
        return ExtensionList.lookup(SCMDecisionHandler.class);
    }

    @CheckForNull
    public static SCMDecisionHandler firstShouldPollVeto(@NonNull Item item) {
        for (SCMDecisionHandler handler : SCMDecisionHandler.all()) {
            if (handler.shouldPoll(item)) continue;
            return handler;
        }
        return null;
    }

    @NonNull
    public static List<SCMDecisionHandler> listShouldPollVetos(@NonNull Item item) {
        ArrayList<SCMDecisionHandler> result = new ArrayList<SCMDecisionHandler>();
        for (SCMDecisionHandler handler : SCMDecisionHandler.all()) {
            if (handler.shouldPoll(item)) continue;
            result.add(handler);
        }
        return result;
    }
}

