/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.navigation;

import hudson.Extension;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.RootAction;
import hudson.model.User;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(ordinal=-1.0)
public class UserAction
implements RootAction {
    @Override
    public String getIconFileName() {
        User current = User.current();
        if (current == null) {
            return null;
        }
        return Functions.getAvatar(current, "96x96");
    }

    @Override
    public String getDisplayName() {
        User current = User.current();
        if (current == null) {
            return null;
        }
        return current.getFullName();
    }

    @Override
    public String getUrlName() {
        User current = User.current();
        if (current == null) {
            return null;
        }
        return current.getUrl();
    }

    @Restricted(value={NoExternalUse.class})
    public User getUser() {
        return User.current();
    }

    @Override
    public boolean isPrimaryAction() {
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    public List<Action> getActions() {
        User current = User.current();
        if (User.current() == null) {
            return null;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(current.getPropertyActions());
        actions.addAll(current.getTransientActions());
        return actions.stream().filter(e -> e.getIconFileName() != null).toList();
    }
}

