/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.model.LoadStatistics;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.SubTask;
import hudson.util.Iterators;
import java.util.Iterator;
import jenkins.model.Jenkins;

public class UnlabeledLoadStatistics
extends LoadStatistics {
    private final Iterable<Node> nodes = new UnlabeledNodesIterable();

    UnlabeledLoadStatistics() {
        super(0, 0);
    }

    @Override
    protected Iterable<Node> getNodes() {
        return this.nodes;
    }

    @Override
    protected boolean matches(Queue.Item item, SubTask subTask) {
        return item.getAssignedLabelFor(subTask) == null;
    }

    private static class UnlabeledNodesIterable
    implements Iterable<Node> {
        private UnlabeledNodesIterable() {
        }

        @Override
        public Iterator<Node> iterator() {
            return new UnlabeledNodesIterator();
        }
    }

    private static class UnlabeledNodesIterator
    extends Iterators.FilterIterator<Node> {
        protected UnlabeledNodesIterator() {
            super(Jenkins.get().getNodes().iterator());
        }

        @Override
        protected boolean filter(Node n) {
            return n != null && n.getMode() == Node.Mode.NORMAL;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

