/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class KeyedDataStorage<T, P> {
    private final ConcurrentHashMap<String, Object> core = new ConcurrentHashMap();
    public final AtomicInteger totalQuery = new AtomicInteger();
    public final AtomicInteger cacheHit = new AtomicInteger();
    public final AtomicInteger weakRefLost = new AtomicInteger();
    public final AtomicInteger loadFailure = new AtomicInteger();

    @NonNull
    public T getOrCreate(String key, P createParams) throws IOException {
        return this.get(key, true, createParams);
    }

    @CheckForNull
    public T get(String key) throws IOException {
        return this.get(key, false, null);
    }

    @CheckForNull
    protected T get(@NonNull String key, boolean createIfNotExist, P createParams) throws IOException {
        Object t;
        Loading l;
        Object value;
        do {
            Object t2;
            this.totalQuery.incrementAndGet();
            value = this.core.get(key);
            if (value instanceof SoftReference) {
                SoftReference wfp = (SoftReference)value;
                t = wfp.get();
                if (t != null) {
                    this.cacheHit.incrementAndGet();
                    return t;
                }
                this.weakRefLost.incrementAndGet();
            }
            if (value instanceof Loading && ((t2 = ((Loading)value).get()) != null || !createIfNotExist)) {
                return t2;
            }
            l = new Loading();
        } while (value == null ? this.core.putIfAbsent(key, l) != null : !this.core.replace(key, value, l));
        t = null;
        try {
            t = this.load(key);
            if (t == null && createIfNotExist && (t = this.create(key, createParams)) == null) {
                throw new IllegalStateException("Bug in the derived class");
            }
        }
        catch (IOException e) {
            this.loadFailure.incrementAndGet();
            throw e;
        }
        finally {
            l.set(t);
        }
        if (t != null) {
            this.core.put(key, new SoftReference(t));
        } else {
            this.core.remove(key);
        }
        return t;
    }

    @CheckForNull
    protected abstract T load(String var1) throws IOException;

    @NonNull
    protected abstract T create(@NonNull String var1, @NonNull P var2) throws IOException;

    public void resetPerformanceStats() {
        this.totalQuery.set(0);
        this.cacheHit.set(0);
        this.weakRefLost.set(0);
        this.loadFailure.set(0);
    }

    public String getPerformanceStats() {
        int total = this.totalQuery.get();
        int hit = this.cacheHit.get();
        int weakRef = this.weakRefLost.get();
        int failure = this.loadFailure.get();
        int miss = total - hit - weakRef;
        return MessageFormat.format("total={0} hit={1}% lostRef={2}% failure={3}% miss={4}%", total, hit, weakRef, failure, miss);
    }

    private static class Loading<T> {
        @CheckForNull
        private T value;
        private boolean set;

        private Loading() {
        }

        public synchronized void set(@CheckForNull T value) {
            this.set = true;
            this.value = value;
            this.notifyAll();
        }

        @CheckForNull
        public synchronized T get() {
            try {
                while (!this.set) {
                    this.wait();
                }
                return this.value;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
    }
}

