/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Messages;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.util.FormValidation;
import io.jenkins.servlet.ServletExceptionWrapper;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerFallback;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ProxyView
extends View
implements StaplerFallback {
    private String proxiedViewName;

    @DataBoundConstructor
    public ProxyView(String name) {
        super(name);
        if (Jenkins.get().getView(name) != null) {
            this.proxiedViewName = name;
        }
    }

    public View getProxiedView() {
        if (this.proxiedViewName == null) {
            return Jenkins.get().getPrimaryView();
        }
        return Jenkins.get().getView(this.proxiedViewName);
    }

    public String getProxiedViewName() {
        return this.proxiedViewName;
    }

    public void setProxiedViewName(String proxiedViewName) {
        this.proxiedViewName = proxiedViewName;
    }

    @Override
    public Collection<TopLevelItem> getItems() {
        return this.getProxiedView().getItems();
    }

    @Override
    public boolean contains(TopLevelItem item) {
        return this.getProxiedView().contains(item);
    }

    @Override
    public TopLevelItem getItem(String name) {
        return this.getProxiedView().getItem(name);
    }

    @Override
    protected void submit(StaplerRequest2 req) throws IOException, jakarta.servlet.ServletException, Descriptor.FormException {
        if (Util.isOverridden(ProxyView.class, this.getClass(), "submit", StaplerRequest.class)) {
            try {
                this.submit(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
            }
        } else {
            this.submitImpl(req);
        }
    }

    @Override
    @Deprecated
    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        try {
            this.submitImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    private void submitImpl(StaplerRequest2 req) throws jakarta.servlet.ServletException, Descriptor.FormException {
        String proxiedViewName = req.getSubmittedForm().getString("proxiedViewName");
        if (Jenkins.get().getView(proxiedViewName) == null) {
            throw new Descriptor.FormException("Not an existing global view", "proxiedViewName");
        }
        this.proxiedViewName = proxiedViewName;
    }

    @Override
    @RequirePOST
    public Item doCreateItem(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        return this.getProxiedView().doCreateItem(req, rsp);
    }

    public FormValidation doViewExistsCheck(@QueryParameter String value) {
        this.checkPermission(View.CREATE);
        String view = Util.fixEmpty(value);
        if (view == null) {
            return FormValidation.ok();
        }
        if (Jenkins.get().getView(view) != null) {
            return FormValidation.ok();
        }
        return FormValidation.error(Messages.ProxyView_NoSuchViewExists(value));
    }

    public Object getStaplerFallback() {
        return this.getProxiedView();
    }

    @Extension
    @Symbol(value={"proxy"})
    public static class DescriptorImpl
    extends ViewDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.ProxyView_DisplayName();
        }

        @Override
        public boolean isInstantiable() {
            return !(Stapler.getCurrentRequest2().findAncestorObject(ViewGroup.class) instanceof Jenkins);
        }
    }
}

