/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.FoldableAction;
import hudson.util.XStream2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class CauseAction
implements FoldableAction,
RunAction2 {
    @Deprecated
    private transient Cause cause;
    @Deprecated
    private transient List<Cause> causes;
    private Map<Cause, Integer> causeBag = new LinkedHashMap<Cause, Integer>();

    public CauseAction(Cause c) {
        this.causeBag.put(c, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCause(Cause c) {
        Map<Cause, Integer> map = this.causeBag;
        synchronized (map) {
            this.causeBag.compute(c, (unused, cnt) -> cnt == null ? 1 : cnt + 1);
        }
    }

    private void addCauses(Collection<? extends Cause> causes) {
        for (Cause cause : causes) {
            this.addCause(cause);
        }
    }

    public CauseAction(Cause ... c) {
        this(Arrays.asList(c));
    }

    public CauseAction(Collection<? extends Cause> causes) {
        this.addCauses(causes);
    }

    public CauseAction(CauseAction ca) {
        this.addCauses(ca.getCauses());
    }

    @Exported(visibility=2)
    public List<Cause> getCauses() {
        ArrayList<Cause> r = new ArrayList<Cause>();
        for (Map.Entry<Cause, Integer> entry : this.causeBag.entrySet()) {
            r.addAll(Collections.nCopies(entry.getValue(), entry.getKey()));
        }
        return Collections.unmodifiableList(r);
    }

    public <T extends Cause> T findCause(Class<T> type) {
        for (Cause c : this.causeBag.keySet()) {
            if (!type.isInstance(c)) continue;
            return (T)((Cause)type.cast(c));
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Cause";
    }

    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getUrlName() {
        return "cause";
    }

    public Map<Cause, Integer> getCauseCounts() {
        return Collections.unmodifiableMap(this.causeBag);
    }

    @Deprecated
    public String getShortDescription() {
        if (this.causeBag.isEmpty()) {
            return "N/A";
        }
        return this.causeBag.keySet().iterator().next().getShortDescription();
    }

    @Override
    public void onLoad(Run<?, ?> owner) {
        for (Cause c : this.causeBag.keySet()) {
            if (c == null) continue;
            c.onLoad(owner);
        }
    }

    @Override
    public void onAttached(Run<?, ?> owner) {
        for (Cause c : this.causeBag.keySet()) {
            if (c == null) continue;
            c.onAddedTo(owner);
        }
    }

    @Override
    public void foldIntoExisting(Queue.Item item, Queue.Task owner, List<Action> otherActions) {
        CauseAction existing = item.getAction(CauseAction.class);
        if (existing != null) {
            existing.addCauses(this.getCauses());
            return;
        }
        item.addAction(new CauseAction(this));
    }

    public static class ConverterImpl
    extends XStream2.PassthruConverter<CauseAction> {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        @Override
        protected void callback(CauseAction ca, UnmarshallingContext context) {
            if (ca.cause != null) {
                if (ca.causeBag == null) {
                    ca.causeBag = new LinkedHashMap<Cause, Integer>();
                }
                ca.addCause(ca.cause);
                OldDataMonitor.report(context, "1.288");
                ca.cause = null;
            } else if (ca.causes != null) {
                if (ca.causeBag == null) {
                    ca.causeBag = new LinkedHashMap<Cause, Integer>();
                }
                ca.addCauses(ca.causes);
                OldDataMonitor.report(context, "1.653");
                ca.causes = null;
            }
        }
    }
}

