/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.object.AbstractObjectMorpher;

public final class DateMorpher
extends AbstractObjectMorpher {
    private Date defaultValue;
    private String[] formats;
    private boolean lenient;
    private Locale locale;

    public DateMorpher(String[] formats) {
        this(formats, Locale.getDefault(), false);
    }

    public DateMorpher(String[] formats, boolean lenient) {
        this(formats, Locale.getDefault(), lenient);
    }

    public DateMorpher(String[] formats, Date defaultValue) {
        this(formats, defaultValue, Locale.getDefault(), false);
    }

    public DateMorpher(String[] formats, Date defaultValue, Locale locale, boolean lenient) {
        super(true);
        if (formats == null || formats.length == 0) {
            throw new MorphException("invalid array of formats");
        }
        this.formats = formats;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.lenient = lenient;
        this.setDefaultValue(defaultValue);
    }

    public DateMorpher(String[] formats, Locale locale) {
        this(formats, locale, false);
    }

    public DateMorpher(String[] formats, Locale locale, boolean lenient) {
        if (formats == null || formats.length == 0) {
            throw new MorphException("invalid array of formats");
        }
        this.formats = formats;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.lenient = lenient;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateMorpher)) {
            return false;
        }
        DateMorpher other = (DateMorpher)obj;
        if (!Arrays.equals(this.formats, other.formats) || !Objects.equals(this.locale, other.locale) || this.lenient != other.lenient) {
            return false;
        }
        if (this.isUseDefault() && other.isUseDefault()) {
            return Objects.equals(this.getDefaultValue(), other.getDefaultValue());
        }
        return !this.isUseDefault() && !other.isUseDefault();
    }

    public Date getDefaultValue() {
        return (Date)this.defaultValue.clone();
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.formats);
        result = 31 * result + Objects.hashCode(this.locale);
        result = 31 * result + Boolean.hashCode(this.lenient);
        if (this.isUseDefault()) {
            result = 31 * result + Objects.hashCode(this.getDefaultValue());
        }
        return result;
    }

    @Override
    public Object morph(Object value) {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(value.getClass())) {
            return (Date)value;
        }
        if (!this.supports(value.getClass())) {
            throw new MorphException(String.valueOf(value.getClass()) + " is not supported");
        }
        String strValue = (String)value;
        SimpleDateFormat dateParser = null;
        for (String format : this.formats) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(format, this.locale);
            } else {
                dateParser.applyPattern(format);
            }
            dateParser.setLenient(this.lenient);
            try {
                return dateParser.parse(strValue.toLowerCase());
            }
            catch (ParseException parseException) {
            }
        }
        if (this.isUseDefault()) {
            return this.defaultValue;
        }
        throw new MorphException("Unable to parse the date " + String.valueOf(value));
    }

    @Override
    public Class morphsTo() {
        return Date.class;
    }

    public void setDefaultValue(Date defaultValue) {
        this.defaultValue = (Date)defaultValue.clone();
    }

    @Override
    public boolean supports(Class clazz) {
        return String.class.isAssignableFrom(clazz);
    }
}

