/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.servlet.http;

import io.jenkins.servlet.AsyncContextWrapper;
import io.jenkins.servlet.DispatcherTypeWrapper;
import io.jenkins.servlet.RequestDispatcherWrapper;
import io.jenkins.servlet.ServletContextWrapper;
import io.jenkins.servlet.ServletExceptionWrapper;
import io.jenkins.servlet.ServletInputStreamWrapper;
import io.jenkins.servlet.ServletRequestWrapper;
import io.jenkins.servlet.ServletResponseWrapper;
import io.jenkins.servlet.http.CookieWrapper;
import io.jenkins.servlet.http.HttpServletMappingWrapper;
import io.jenkins.servlet.http.HttpServletResponseWrapper;
import io.jenkins.servlet.http.HttpSessionWrapper;
import io.jenkins.servlet.http.PartWrapper;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class HttpServletRequestWrapper {
    public static jakarta.servlet.http.HttpServletRequest toJakartaHttpServletRequest(HttpServletRequest from) {
        if (from instanceof JavaxHttpServletRequestWrapper) {
            JavaxHttpServletRequestWrapper javax = (JavaxHttpServletRequestWrapper)from;
            return javax.toJakartaHttpServletRequest();
        }
        return new JakartaHttpServletRequestWrapperImpl(from);
    }

    public static HttpServletRequest fromJakartaHttpServletRequest(jakarta.servlet.http.HttpServletRequest from) {
        if (from instanceof JakartaHttpServletRequestWrapper) {
            JakartaHttpServletRequestWrapper jakarta = (JakartaHttpServletRequestWrapper)from;
            return jakarta.toJavaxHttpServletRequest();
        }
        return new JavaxHttpServletRequestWrapperImpl(from);
    }

    public static interface JavaxHttpServletRequestWrapper {
        public jakarta.servlet.http.HttpServletRequest toJakartaHttpServletRequest();
    }

    private static class JakartaHttpServletRequestWrapperImpl
    implements jakarta.servlet.http.HttpServletRequest,
    ServletRequestWrapper.JakartaServletRequestWrapper {
        private final HttpServletRequest from;

        JakartaHttpServletRequestWrapperImpl(HttpServletRequest from) {
            this.from = Objects.requireNonNull(from);
        }

        public Object getAttribute(String name) {
            return this.from.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            return this.from.getAttributeNames();
        }

        public String getCharacterEncoding() {
            return this.from.getCharacterEncoding();
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
            this.from.setCharacterEncoding(env);
        }

        public int getContentLength() {
            return this.from.getContentLength();
        }

        public long getContentLengthLong() {
            return this.from.getContentLengthLong();
        }

        public String getContentType() {
            return this.from.getContentType();
        }

        public ServletInputStream getInputStream() throws IOException {
            return ServletInputStreamWrapper.toJakartaServletInputStream(this.from.getInputStream());
        }

        public String getParameter(String name) {
            return this.from.getParameter(name);
        }

        public Enumeration<String> getParameterNames() {
            return this.from.getParameterNames();
        }

        public String[] getParameterValues(String name) {
            return this.from.getParameterValues(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.from.getParameterMap();
        }

        public String getProtocol() {
            return this.from.getProtocol();
        }

        public String getScheme() {
            return this.from.getScheme();
        }

        public String getServerName() {
            return this.from.getServerName();
        }

        public int getServerPort() {
            return this.from.getServerPort();
        }

        public BufferedReader getReader() throws IOException {
            return this.from.getReader();
        }

        public String getRemoteAddr() {
            return this.from.getRemoteAddr();
        }

        public String getRemoteHost() {
            return this.from.getRemoteHost();
        }

        public void setAttribute(String name, Object o) {
            this.from.setAttribute(name, o);
        }

        public void removeAttribute(String name) {
            this.from.removeAttribute(name);
        }

        public Locale getLocale() {
            return this.from.getLocale();
        }

        public Enumeration<Locale> getLocales() {
            return this.from.getLocales();
        }

        public boolean isSecure() {
            return this.from.isSecure();
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            javax.servlet.RequestDispatcher requestDispatcher = this.from.getRequestDispatcher(path);
            return requestDispatcher != null ? RequestDispatcherWrapper.toJakartaRequestDispatcher(requestDispatcher) : null;
        }

        public String getRealPath(String path) {
            return this.from.getRealPath(path);
        }

        public int getRemotePort() {
            return this.from.getRemotePort();
        }

        public String getLocalName() {
            return this.from.getLocalName();
        }

        public String getLocalAddr() {
            return this.from.getLocalAddr();
        }

        public int getLocalPort() {
            return this.from.getLocalPort();
        }

        public ServletContext getServletContext() {
            return ServletContextWrapper.toJakartaServletContext(this.from.getServletContext());
        }

        public AsyncContext startAsync() {
            return AsyncContextWrapper.toJakartaAsyncContext(this.from.startAsync());
        }

        public AsyncContext startAsync(jakarta.servlet.ServletRequest servletRequest, jakarta.servlet.ServletResponse servletResponse) {
            return AsyncContextWrapper.toJakartaAsyncContext(this.from.startAsync(ServletRequestWrapper.fromJakartaServletRequest(servletRequest), ServletResponseWrapper.fromJakartaServletResponse(servletResponse)));
        }

        public boolean isAsyncStarted() {
            return this.from.isAsyncStarted();
        }

        public boolean isAsyncSupported() {
            return this.from.isAsyncSupported();
        }

        public AsyncContext getAsyncContext() {
            return AsyncContextWrapper.toJakartaAsyncContext(this.from.getAsyncContext());
        }

        public DispatcherType getDispatcherType() {
            return DispatcherTypeWrapper.toJakartaDispatcherType(this.from.getDispatcherType());
        }

        public String getAuthType() {
            return this.from.getAuthType();
        }

        public jakarta.servlet.http.Cookie[] getCookies() {
            Cookie[] cookies = this.from.getCookies();
            if (cookies == null) {
                return null;
            }
            return (jakarta.servlet.http.Cookie[])Stream.of(cookies).map(CookieWrapper::toJakartaServletHttpCookie).toArray(jakarta.servlet.http.Cookie[]::new);
        }

        public long getDateHeader(String name) {
            return this.from.getDateHeader(name);
        }

        public String getHeader(String name) {
            return this.from.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            return this.from.getHeaders(name);
        }

        public Enumeration<String> getHeaderNames() {
            return this.from.getHeaderNames();
        }

        public int getIntHeader(String name) {
            return this.from.getIntHeader(name);
        }

        public HttpServletMapping getHttpServletMapping() {
            return HttpServletMappingWrapper.toJakartaHttpServletMapping(this.from.getHttpServletMapping());
        }

        public String getMethod() {
            return this.from.getMethod();
        }

        public String getPathInfo() {
            return this.from.getPathInfo();
        }

        public String getPathTranslated() {
            return this.from.getPathTranslated();
        }

        public PushBuilder newPushBuilder() {
            throw new UnsupportedOperationException();
        }

        public String getContextPath() {
            return this.from.getContextPath();
        }

        public String getQueryString() {
            return this.from.getQueryString();
        }

        public String getRemoteUser() {
            return this.from.getRemoteUser();
        }

        public boolean isUserInRole(String role) {
            return this.from.isUserInRole(role);
        }

        public Principal getUserPrincipal() {
            return this.from.getUserPrincipal();
        }

        public String getRequestedSessionId() {
            return this.from.getRequestedSessionId();
        }

        public String getRequestURI() {
            return this.from.getRequestURI();
        }

        public StringBuffer getRequestURL() {
            return this.from.getRequestURL();
        }

        public String getServletPath() {
            return this.from.getServletPath();
        }

        public jakarta.servlet.http.HttpSession getSession(boolean create) {
            HttpSession session = this.from.getSession(create);
            return session != null ? HttpSessionWrapper.toJakartaHttpSession(session) : null;
        }

        public jakarta.servlet.http.HttpSession getSession() {
            HttpSession session = this.from.getSession();
            return session != null ? HttpSessionWrapper.toJakartaHttpSession(session) : null;
        }

        public String changeSessionId() {
            return this.from.changeSessionId();
        }

        public boolean isRequestedSessionIdValid() {
            return this.from.isRequestedSessionIdValid();
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.from.isRequestedSessionIdFromCookie();
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.from.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.from.isRequestedSessionIdFromUrl();
        }

        public boolean authenticate(HttpServletResponse response) throws IOException, jakarta.servlet.ServletException {
            try {
                return this.from.authenticate(HttpServletResponseWrapper.fromJakartaHttpServletResponse(response));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException(e);
            }
        }

        public void login(String username, String password) throws jakarta.servlet.ServletException {
            try {
                this.from.login(username, password);
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException(e);
            }
        }

        public void logout() throws jakarta.servlet.ServletException {
            try {
                this.from.logout();
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException(e);
            }
        }

        public Collection<jakarta.servlet.http.Part> getParts() throws IOException, jakarta.servlet.ServletException {
            try {
                return this.from.getParts().stream().map(PartWrapper::toJakartaPart).collect(Collectors.toCollection(ArrayList::new));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException(e);
            }
        }

        public jakarta.servlet.http.Part getPart(String name) throws IOException, jakarta.servlet.ServletException {
            try {
                return PartWrapper.toJakartaPart(this.from.getPart(name));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException(e);
            }
        }

        public <T extends jakarta.servlet.http.HttpUpgradeHandler> T upgrade(Class<T> handlerClass) {
            throw new UnsupportedOperationException();
        }

        public Map<String, String> getTrailerFields() {
            return this.from.getTrailerFields();
        }

        public boolean isTrailerFieldsReady() {
            return this.from.isTrailerFieldsReady();
        }

        public HttpServletRequest toJavaxServletRequest() {
            return this.from;
        }
    }

    public static interface JakartaHttpServletRequestWrapper {
        public HttpServletRequest toJavaxHttpServletRequest();
    }

    private static class JavaxHttpServletRequestWrapperImpl
    implements HttpServletRequest,
    ServletRequestWrapper.JavaxServletRequestWrapper {
        private final jakarta.servlet.http.HttpServletRequest from;

        JavaxHttpServletRequestWrapperImpl(jakarta.servlet.http.HttpServletRequest from) {
            this.from = Objects.requireNonNull(from);
        }

        public Object getAttribute(String name) {
            return this.from.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            return this.from.getAttributeNames();
        }

        public String getCharacterEncoding() {
            return this.from.getCharacterEncoding();
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
            this.from.setCharacterEncoding(env);
        }

        public int getContentLength() {
            return this.from.getContentLength();
        }

        public long getContentLengthLong() {
            return this.from.getContentLengthLong();
        }

        public String getContentType() {
            return this.from.getContentType();
        }

        public javax.servlet.ServletInputStream getInputStream() throws IOException {
            return ServletInputStreamWrapper.fromJakartaServletInputStream(this.from.getInputStream());
        }

        public String getParameter(String name) {
            return this.from.getParameter(name);
        }

        public Enumeration<String> getParameterNames() {
            return this.from.getParameterNames();
        }

        public String[] getParameterValues(String name) {
            return this.from.getParameterValues(name);
        }

        public Map<String, String[]> getParameterMap() {
            return this.from.getParameterMap();
        }

        public String getProtocol() {
            return this.from.getProtocol();
        }

        public String getScheme() {
            return this.from.getScheme();
        }

        public String getServerName() {
            return this.from.getServerName();
        }

        public int getServerPort() {
            return this.from.getServerPort();
        }

        public BufferedReader getReader() throws IOException {
            return this.from.getReader();
        }

        public String getRemoteAddr() {
            return this.from.getRemoteAddr();
        }

        public String getRemoteHost() {
            return this.from.getRemoteHost();
        }

        public void setAttribute(String name, Object o) {
            this.from.setAttribute(name, o);
        }

        public void removeAttribute(String name) {
            this.from.removeAttribute(name);
        }

        public Locale getLocale() {
            return this.from.getLocale();
        }

        public Enumeration<Locale> getLocales() {
            return this.from.getLocales();
        }

        public boolean isSecure() {
            return this.from.isSecure();
        }

        public javax.servlet.RequestDispatcher getRequestDispatcher(String path) {
            RequestDispatcher requestDispatcher = this.from.getRequestDispatcher(path);
            return requestDispatcher != null ? RequestDispatcherWrapper.fromJakartaRequestDispatcher(requestDispatcher) : null;
        }

        public String getRealPath(String path) {
            return this.from.getRealPath(path);
        }

        public int getRemotePort() {
            return this.from.getRemotePort();
        }

        public String getLocalName() {
            return this.from.getLocalName();
        }

        public String getLocalAddr() {
            return this.from.getLocalAddr();
        }

        public int getLocalPort() {
            return this.from.getLocalPort();
        }

        public javax.servlet.ServletContext getServletContext() {
            return ServletContextWrapper.fromJakartServletContext(this.from.getServletContext());
        }

        public javax.servlet.AsyncContext startAsync() {
            return AsyncContextWrapper.fromJakartaAsyncContext(this.from.startAsync());
        }

        public javax.servlet.AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
            return AsyncContextWrapper.fromJakartaAsyncContext(this.from.startAsync(ServletRequestWrapper.toJakartaServletRequest(servletRequest), ServletResponseWrapper.toJakartaServletResponse(servletResponse)));
        }

        public boolean isAsyncStarted() {
            return this.from.isAsyncStarted();
        }

        public boolean isAsyncSupported() {
            return this.from.isAsyncSupported();
        }

        public javax.servlet.AsyncContext getAsyncContext() {
            return AsyncContextWrapper.fromJakartaAsyncContext(this.from.getAsyncContext());
        }

        public javax.servlet.DispatcherType getDispatcherType() {
            return DispatcherTypeWrapper.fromJakartaDispatcherType(this.from.getDispatcherType());
        }

        public String getAuthType() {
            return this.from.getAuthType();
        }

        public Cookie[] getCookies() {
            jakarta.servlet.http.Cookie[] cookies = this.from.getCookies();
            if (cookies == null) {
                return null;
            }
            return (Cookie[])Stream.of(cookies).map(CookieWrapper::fromJakartaServletHttpCookie).toArray(Cookie[]::new);
        }

        public long getDateHeader(String name) {
            return this.from.getDateHeader(name);
        }

        public String getHeader(String name) {
            return this.from.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            return this.from.getHeaders(name);
        }

        public Enumeration<String> getHeaderNames() {
            return this.from.getHeaderNames();
        }

        public int getIntHeader(String name) {
            return this.from.getIntHeader(name);
        }

        public javax.servlet.http.HttpServletMapping getHttpServletMapping() {
            return HttpServletMappingWrapper.fromJakartaHttpServletMapping(this.from.getHttpServletMapping());
        }

        public String getMethod() {
            return this.from.getMethod();
        }

        public String getPathInfo() {
            return this.from.getPathInfo();
        }

        public String getPathTranslated() {
            return this.from.getPathTranslated();
        }

        public javax.servlet.http.PushBuilder newPushBuilder() {
            throw new UnsupportedOperationException();
        }

        public String getContextPath() {
            return this.from.getContextPath();
        }

        public String getQueryString() {
            return this.from.getQueryString();
        }

        public String getRemoteUser() {
            return this.from.getRemoteUser();
        }

        public boolean isUserInRole(String role) {
            return this.from.isUserInRole(role);
        }

        public Principal getUserPrincipal() {
            return this.from.getUserPrincipal();
        }

        public String getRequestedSessionId() {
            return this.from.getRequestedSessionId();
        }

        public String getRequestURI() {
            return this.from.getRequestURI();
        }

        public StringBuffer getRequestURL() {
            return this.from.getRequestURL();
        }

        public String getServletPath() {
            return this.from.getServletPath();
        }

        public HttpSession getSession(boolean create) {
            jakarta.servlet.http.HttpSession session = this.from.getSession(create);
            return session != null ? HttpSessionWrapper.fromJakartaHttpSession(session) : null;
        }

        public HttpSession getSession() {
            jakarta.servlet.http.HttpSession session = this.from.getSession();
            return session != null ? HttpSessionWrapper.fromJakartaHttpSession(session) : null;
        }

        public String changeSessionId() {
            return this.from.changeSessionId();
        }

        public boolean isRequestedSessionIdValid() {
            return this.from.isRequestedSessionIdValid();
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.from.isRequestedSessionIdFromCookie();
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.from.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.from.isRequestedSessionIdFromUrl();
        }

        public boolean authenticate(javax.servlet.http.HttpServletResponse response) throws IOException, ServletException {
            try {
                return this.from.authenticate(HttpServletResponseWrapper.toJakartaHttpServletResponse(response));
            }
            catch (jakarta.servlet.ServletException e) {
                throw ServletExceptionWrapper.fromJakartaServletException(e);
            }
        }

        public void login(String username, String password) throws ServletException {
            try {
                this.from.login(username, password);
            }
            catch (jakarta.servlet.ServletException e) {
                throw ServletExceptionWrapper.fromJakartaServletException(e);
            }
        }

        public void logout() throws ServletException {
            try {
                this.from.logout();
            }
            catch (jakarta.servlet.ServletException e) {
                throw ServletExceptionWrapper.fromJakartaServletException(e);
            }
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            try {
                return this.from.getParts().stream().map(PartWrapper::fromJakartaPart).collect(Collectors.toCollection(ArrayList::new));
            }
            catch (jakarta.servlet.ServletException e) {
                throw ServletExceptionWrapper.fromJakartaServletException(e);
            }
        }

        public Part getPart(String name) throws IOException, ServletException {
            try {
                return PartWrapper.fromJakartaPart(this.from.getPart(name));
            }
            catch (jakarta.servlet.ServletException e) {
                throw ServletExceptionWrapper.fromJakartaServletException(e);
            }
        }

        public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) {
            throw new UnsupportedOperationException();
        }

        public Map<String, String> getTrailerFields() {
            return this.from.getTrailerFields();
        }

        public boolean isTrailerFieldsReady() {
            return this.from.isTrailerFieldsReady();
        }

        public jakarta.servlet.http.HttpServletRequest toJakartaServletRequest() {
            return this.from;
        }
    }
}

