/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.security.eddsa.generic;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.eddsa.generic.EdDSASupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class GenericEd25519PublicKeyDecoder<PUB extends PublicKey, PRV extends PrivateKey>
extends AbstractPublicKeyEntryDecoder<PUB, PRV> {
    public static final int MAX_ALLOWED_SEED_LEN = 1024;
    protected final EdDSASupport<PUB, PRV> edDSASupport;

    public GenericEd25519PublicKeyDecoder(Class<PUB> pubType, Class<PRV> prvType, EdDSASupport<PUB, PRV> edDSASupport) {
        super(pubType, prvType, Collections.singletonList("ssh-ed25519"));
        this.edDSASupport = edDSASupport;
    }

    @Override
    public PUB clonePublicKey(PUB key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        return this.generatePublicKey(this.edDSASupport.createPublicKeySpec(key));
    }

    @Override
    public PRV clonePrivateKey(PRV key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        return this.generatePrivateKey(this.edDSASupport.createPrivateKeySpec(key));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("EdDSA");
    }

    @Override
    public String encodePublicKey(OutputStream s, PUB key) throws IOException {
        Objects.requireNonNull(key, "No public key provided");
        KeyEntryResolver.encodeString(s, "ssh-ed25519");
        byte[] seed = this.edDSASupport.getPublicKeyData(key);
        KeyEntryResolver.writeRLEBytes(s, seed);
        return "ssh-ed25519";
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("EdDSA");
    }

    @Override
    public PUB decodePublicKey(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        byte[] seed = KeyEntryResolver.readRLEBytes(keyData, 1024);
        return this.edDSASupport.generateEDDSAPublicKey(seed);
    }
}

