/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.util.introspection;

import java.lang.reflect.Method;
import org.apache.commons.jexl.util.introspection.IntrospectorBase;
import org.apache.commons.jexl.util.introspection.MethodMap;
import org.apache.commons.logging.Log;

public class Introspector
extends IntrospectorBase {
    public static final String CACHEDUMP_MSG = "Introspector : detected classloader change. Dumping cache.";
    private final Log rlog;

    public Introspector(Log logger) {
        super(logger);
        this.rlog = logger;
    }

    public Method getMethod(Class c, String name, Object[] params) throws IllegalArgumentException {
        try {
            return super.getMethod(c, name, params);
        }
        catch (MethodMap.AmbiguousException ae) {
            StringBuffer msg = new StringBuffer("Introspection Error : Ambiguous method invocation ").append(name).append("( ");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(null == params[i] ? "null" : params[i].getClass().getName());
            }
            msg.append(") for class ").append(c.getName());
            this.rlog.error((Object)msg.toString());
            return null;
        }
    }

    protected void clearCache() {
        super.clearCache();
        this.rlog.info((Object)CACHEDUMP_MSG);
    }
}

