/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.parser;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.ParserVisitor;
import org.apache.commons.jexl.parser.SimpleNode;
import org.apache.commons.jexl.util.introspection.Info;
import org.apache.commons.jexl.util.introspection.Uberspect;
import org.apache.commons.jexl.util.introspection.VelMethod;

public class ASTSizeFunction
extends SimpleNode {
    public ASTSizeFunction(int id) {
        super(id);
    }

    public ASTSizeFunction(Parser p, int id) {
        super(p, id);
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object value(JexlContext jc) throws Exception {
        SimpleNode arg = (SimpleNode)this.jjtGetChild(0);
        Object val = arg.value(jc);
        if (val == null) {
            throw new Exception("size() : null arg");
        }
        return new Integer(ASTSizeFunction.sizeOf(val, this.getUberspect()));
    }

    public static int sizeOf(Object val, Uberspect uberspect) throws Exception {
        if (val instanceof Collection) {
            return ((Collection)val).size();
        }
        if (val.getClass().isArray()) {
            return Array.getLength(val);
        }
        if (val instanceof Map) {
            return ((Map)val).size();
        }
        if (val instanceof String) {
            return ((String)val).length();
        }
        Object[] params = new Object[0];
        Info velInfo = new Info("", 1, 1);
        VelMethod vm = uberspect.getMethod(val, "size", params, velInfo);
        if (vm != null && vm.getReturnType() == Integer.TYPE) {
            Integer result = (Integer)vm.invoke(val, params);
            return result;
        }
        throw new Exception("size() : unknown type : " + val.getClass());
    }
}

