/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.security.UserMayOrMayNotExistException2;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Restricted(value={NoExternalUse.class})
@Extension
public final class UserDetailsCache {
    private static final String SYS_PROP_NAME = UserDetailsCache.class.getName() + ".EXPIRE_AFTER_WRITE_SEC";
    private static Integer EXPIRE_AFTER_WRITE_SEC = SystemProperties.getInteger(SYS_PROP_NAME, (int)TimeUnit.MINUTES.toSeconds(2L));
    private final Cache<String, UserDetails> detailsCache;
    private final Cache<String, Boolean> existenceCache;

    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="field is static for script console")
    public UserDetailsCache() {
        Integer expireAfterWriteSec = EXPIRE_AFTER_WRITE_SEC;
        if (expireAfterWriteSec == null || expireAfterWriteSec <= 0) {
            expireAfterWriteSec = SystemProperties.getInteger(SYS_PROP_NAME, (int)TimeUnit.MINUTES.toSeconds(2L));
            if (expireAfterWriteSec <= 0) {
                expireAfterWriteSec = (int)TimeUnit.MINUTES.toSeconds(2L);
            }
            EXPIRE_AFTER_WRITE_SEC = expireAfterWriteSec;
        }
        this.detailsCache = CacheBuilder.newBuilder().softValues().expireAfterWrite((long)EXPIRE_AFTER_WRITE_SEC.intValue(), TimeUnit.SECONDS).build();
        this.existenceCache = CacheBuilder.newBuilder().softValues().expireAfterWrite((long)EXPIRE_AFTER_WRITE_SEC.intValue(), TimeUnit.SECONDS).build();
    }

    public static UserDetailsCache get() {
        return ExtensionList.lookupSingleton(UserDetailsCache.class);
    }

    @CheckForNull
    public UserDetails getCached(String idOrFullName) throws UsernameNotFoundException {
        Boolean exists = (Boolean)this.existenceCache.getIfPresent((Object)idOrFullName);
        if (exists != null && !exists.booleanValue()) {
            throw new UserMayOrMayNotExistException2(String.format("\"%s\" does not exist", idOrFullName));
        }
        return (UserDetails)this.detailsCache.getIfPresent((Object)idOrFullName);
    }

    @NonNull
    public UserDetails loadUserByUsername(String idOrFullName) throws UsernameNotFoundException, ExecutionException {
        Boolean exists = (Boolean)this.existenceCache.getIfPresent((Object)idOrFullName);
        if (exists != null && !exists.booleanValue()) {
            throw new UsernameNotFoundException(String.format("\"%s\" does not exist", idOrFullName));
        }
        try {
            return (UserDetails)this.detailsCache.get((Object)idOrFullName, (Callable)new Retriever(idOrFullName));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            if (e.getCause() instanceof UsernameNotFoundException) {
                throw (UsernameNotFoundException)e.getCause();
            }
            throw e;
        }
    }

    public void invalidateAll() {
        this.existenceCache.invalidateAll();
        this.detailsCache.invalidateAll();
    }

    public void invalidate(String idOrFullName) {
        this.existenceCache.invalidate((Object)idOrFullName);
        this.detailsCache.invalidate((Object)idOrFullName);
    }

    private class Retriever
    implements Callable<UserDetails> {
        private final String idOrFullName;

        private Retriever(String idOrFullName) {
            this.idOrFullName = idOrFullName;
        }

        @Override
        public UserDetails call() throws Exception {
            try {
                Jenkins jenkins = Jenkins.get();
                UserDetails userDetails = jenkins.getSecurityRealm().loadUserByUsername2(this.idOrFullName);
                if (userDetails == null) {
                    UserDetailsCache.this.existenceCache.put((Object)this.idOrFullName, (Object)Boolean.FALSE);
                    throw new NullPointerException("hudson.security.SecurityRealm should never return null. " + String.valueOf(jenkins.getSecurityRealm()) + " returned null for idOrFullName='" + this.idOrFullName + "'");
                }
                UserDetailsCache.this.existenceCache.put((Object)this.idOrFullName, (Object)Boolean.TRUE);
                return userDetails;
            }
            catch (UsernameNotFoundException e) {
                UserDetailsCache.this.existenceCache.put((Object)this.idOrFullName, (Object)Boolean.FALSE);
                throw e;
            }
        }
    }
}

