/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Queue;
import jenkins.model.FullyNamedModelObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public interface QueueItem
extends FullyNamedModelObject {
    public boolean isStuck();

    @NonNull
    public Queue.Task getTask();

    default public boolean hasCancelPermission() {
        return this.getTask().hasAbortPermission();
    }

    public long getId();

    @NonNull
    public String getCausesDescription();

    @CheckForNull
    public String getWhy();

    @NonNull
    public String getParams();

    @NonNull
    public String getInQueueForString();

    @Override
    @CheckForNull
    default public String getDisplayName() {
        return this.getTask().getFullDisplayName();
    }

    @Override
    default public String getFullDisplayName() {
        return this.getTask().getFullDisplayName();
    }
}

