/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Functions;
import hudson.console.AnnotatedLargeText;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import org.kohsuke.stapler.framework.io.ByteBuffer;
import org.kohsuke.stapler.framework.io.LargeText;

public abstract class TaskThread
extends Thread {
    @Deprecated
    private final LargeText text;
    private final AnnotatedLargeText<TaskAction> log;
    private TaskListener listener;
    private final TaskAction owner;
    private volatile boolean isRunning;

    protected TaskThread(TaskAction owner, ListenerAndText output) {
        super(owner.getDisplayName());
        this.owner = owner;
        this.log = output.text;
        this.text = this.log;
        this.listener = output.listener;
        this.isRunning = true;
    }

    public Reader readAll() throws IOException {
        return this.text.readAll();
    }

    protected final void associateWith(TaskAction action) {
        action.workerThread = this;
        action.log = new WeakReference<AnnotatedLargeText<TaskAction>>(this.log);
    }

    @Override
    public void start() {
        this.associateWith(this.owner);
        super.start();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    protected ListenerAndText createListener() throws IOException {
        return ListenerAndText.forMemory();
    }

    @Override
    public final void run() {
        this.isRunning = true;
        try {
            this.perform(this.listener);
            this.listener.getLogger().println("Completed");
            this.owner.workerThread = null;
        }
        catch (InterruptedException e) {
            this.listener.getLogger().println("Aborted");
        }
        catch (Exception e) {
            Functions.printStackTrace((Throwable)e, this.listener.getLogger());
        }
        finally {
            this.listener = null;
            this.isRunning = false;
        }
        this.log.markAsComplete();
    }

    protected abstract void perform(TaskListener var1) throws Exception;

    public static final class ListenerAndText {
        final TaskListener listener;
        final AnnotatedLargeText<TaskAction> text;

        public ListenerAndText(TaskListener listener, AnnotatedLargeText<TaskAction> text) {
            this.listener = listener;
            this.text = text;
        }

        @Deprecated
        public static ListenerAndText forMemory() {
            return ListenerAndText.forMemory(null);
        }

        @Deprecated
        public static ListenerAndText forFile(File f) throws IOException {
            return ListenerAndText.forFile(f, null);
        }

        public static ListenerAndText forMemory(TaskAction context) {
            ByteBuffer log = new ByteBuffer();
            return new ListenerAndText(new StreamTaskListener((OutputStream)log), new AnnotatedLargeText<TaskAction>(log, Charset.defaultCharset(), false, context));
        }

        public static ListenerAndText forFile(File f, TaskAction context) throws IOException {
            return new ListenerAndText(new StreamTaskListener(f), new AnnotatedLargeText<TaskAction>(f, Charset.defaultCharset(), false, context));
        }
    }
}

